/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigBlockState
extends ConfigValue {
    public static final String ID = "blockstate";
    private IBlockState value;

    public ConfigBlockState(IBlockState state) {
        this.value = state;
    }

    @Override
    public String getID() {
        return ID;
    }

    public IBlockState getBlockState() {
        return this.value;
    }

    public void setBlockState(IBlockState state) {
        this.value = state;
    }

    @Override
    public String getString() {
        return BlockUtils.getNameFromState(this.getBlockState());
    }

    @Override
    public boolean getBoolean() {
        return this.getBlockState() != BlockUtils.AIR_STATE;
    }

    @Override
    public int getInt() {
        return Block.func_176210_f((IBlockState)this.getBlockState());
    }

    @Override
    public ConfigBlockState copy() {
        return new ConfigBlockState(this.getBlockState());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getBlockState();
        nbt.func_74768_a(key, this.value == BlockUtils.AIR_STATE ? 0 : Block.func_176210_f((IBlockState)this.value));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        int id = nbt.func_74762_e(key);
        this.setBlockState(id == 0 ? BlockUtils.AIR_STATE : Block.func_176220_d((int)id));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeBlockState(this.getBlockState());
    }

    @Override
    public void readData(DataIn data) {
        this.setBlockState(data.readBlockState());
    }

    @Override
    public boolean isEmpty() {
        return this.getBlockState() == BlockUtils.AIR_STATE;
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (!simulate) {
            this.setBlockState(BlockUtils.getStateFromName(string));
        }
        return true;
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigBlockState) {
            this.setBlockState(((ConfigBlockState)value).getBlockState());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setBlockState(BlockUtils.getStateFromName(json.getAsString()));
        }
    }
}

