/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import java.util.function.Function;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ClientRegistry {
    public static <T extends Entity> void registerEntityRenderer(EntityType<T> type, IRenderFactory<? super T> rendererFactory) {
        RenderingRegistry.registerEntityRenderingHandler(type, rendererFactory);
    }

    public static <T extends TileEntity> void registerSpecialTileEntityRenderer(TileEntityType<T> type, TileEntityRenderer<? super T> renderer) {
        ClientRegistry.registerSpecialTileEntityRenderer(type, (? super TileEntityRendererDispatcher dispatcher) -> renderer);
    }

    public static <T extends TileEntity> void registerSpecialTileEntityRenderer(TileEntityType<T> type, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>> rendererFactory) {
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer(type, rendererFactory);
    }

    public static void registerKeybinding(KeyBinding key) {
        net.minecraftforge.fml.client.registry.ClientRegistry.registerKeyBinding((KeyBinding)key);
    }
}

