/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import info.u_team.u_team_core.UCoreMain;
import info.u_team.u_team_core.api.registry.IUArrayRegistryType;
import info.u_team.u_team_core.api.registry.IUBlockRegistryType;
import info.u_team.u_team_core.api.registry.IURegistryType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BaseRegistryUtil {
    public static List<BlockItem> getBlockItems(List<Block> blocks) {
        return blocks.parallelStream().filter(block -> block instanceof IUBlockRegistryType).filter(block -> ((IUBlockRegistryType)block).getBlockItem() != null).map(block -> {
            BlockItem blockItem = ((IUBlockRegistryType)block).getBlockItem();
            BaseRegistryUtil.executeWithModContainer(block.getRegistryName().func_110624_b(), () -> {
                Item cfr_ignored_0 = (Item)blockItem.setRegistryName(block.getRegistryName());
            });
            return blockItem;
        }).collect(Collectors.toList());
    }

    public static <C, T extends IForgeRegistryEntry<T>> List<C> getAllGenericRegistryEntriesAndApplyNames(String modid, Class<C> classType) {
        return BaseRegistryUtil.getAllGenericRegistryEntriesAndApplyNames(modid, classType, BaseRegistryUtil.getCallerClass());
    }

    public static <C, T extends IForgeRegistryEntry<T>> List<C> getAllGenericRegistryEntriesAndApplyNames(String modid, Class<C> classType, Class<?> init) {
        return BaseRegistryUtil.getAllRegistryEntriesAndApplyNames(modid, classType, init);
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> getAllRegistryEntriesAndApplyNames(String modid, Class<T> classType) {
        return BaseRegistryUtil.getAllRegistryEntriesAndApplyNames(modid, classType, BaseRegistryUtil.getCallerClass());
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> getAllRegistryEntriesAndApplyNames(String modid, Class<T> classType, Class<?> init) {
        List<T> list = BaseRegistryUtil.getAllClassEntries(classType, init);
        list.parallelStream().filter(entry -> entry instanceof IURegistryType).forEach(entry -> BaseRegistryUtil.executeWithModContainer(modid, () -> {
            IForgeRegistryEntry cfr_ignored_0 = (IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation(modid, ((IURegistryType)entry).getEntryName()));
        }));
        return list;
    }

    public static <T> List<T> getAllClassEntries(Class<T> classType) {
        Class<?> callerClass = BaseRegistryUtil.getCallerClass();
        List<T> list = BaseRegistryUtil.getClassEntries(classType, callerClass);
        list.addAll(BaseRegistryUtil.getClassEntriesFromArrayType(classType, callerClass));
        return list;
    }

    public static <T> List<T> getClassEntries(Class<T> classType) {
        return BaseRegistryUtil.getClassEntries(classType, BaseRegistryUtil.getCallerClass());
    }

    public static <T> List<T> getClassEntriesFromArrayType(Class<T> classType) {
        return BaseRegistryUtil.getClassEntriesFromArrayType(classType, BaseRegistryUtil.getCallerClass());
    }

    public static <T> List<T> getAllClassEntries(Class<T> classType, Class<?> init) {
        List<T> list = BaseRegistryUtil.getClassEntries(classType, init);
        list.addAll(BaseRegistryUtil.getClassEntriesFromArrayType(classType, init));
        return list;
    }

    public static <T> List<T> getClassEntries(Class<T> classType, Class<?> init) {
        return BaseRegistryUtil.applyDefault(classType, Stream.of(init.getDeclaredFields())).collect(Collectors.toList());
    }

    public static <T> List<T> getClassEntriesFromArrayType(Class<T> classType, Class<?> init) {
        return BaseRegistryUtil.applyDefault(IUArrayRegistryType.class, Stream.of(init.getDeclaredFields())).filter(arrayRegistryType -> arrayRegistryType.getArray().getClass().getComponentType().isAssignableFrom(classType)).collect(() -> new ArrayList(), (list, arrayRegistryType) -> BaseRegistryUtil.addGenericArrayElements(list, classType, arrayRegistryType.getArray()), (list, otherList) -> list.addAll(otherList));
    }

    private static <T> Stream<T> applyDefault(Class<T> classCast, Stream<Field> stream) {
        return ((Stream)stream.parallel()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getDeclaredAnnotation(Exclude.class) == null).filter(field -> classCast.isAssignableFrom(field.getType())).map(field -> BaseRegistryUtil.getStaticField(classCast, field));
    }

    private static <T> T getStaticField(Class<T> classCast, Field field) {
        try {
            return classCast.cast(field.get(null));
        }
        catch (Exception ex) {
            UCoreMain.LOGGER.error("Failed fetching field entry {} for class {}.", (Object)field.getName(), field.getClass(), (Object)ex);
            return null;
        }
    }

    private static <T> void addGenericArrayElements(List<T> list, Class<T> classCast, Object[] array) {
        for (Object entry : array) {
            list.add(classCast.cast(entry));
        }
    }

    private static Class<?> getCallerClass() {
        try {
            return Class.forName(Thread.currentThread().getStackTrace()[3].getClassName());
        }
        catch (ClassNotFoundException ex) {
            UCoreMain.LOGGER.error("Failed the get caller class.", (Throwable)ex);
            return null;
        }
    }

    private static synchronized void executeWithModContainer(String modid, Runnable runnable) {
        ModLoadingContext context = ModLoadingContext.get();
        ModContainer activeContainer = context.getActiveContainer();
        Object extention = context.extension();
        ModList.get().getModContainerById(modid).ifPresent(newContainer -> context.setActiveContainer(newContainer, extention));
        runnable.run();
        context.setActiveContainer(activeContainer, extention);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }
}

