/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.spawn.modifiers.CapModifier;
import shadows.apotheosis.spawn.modifiers.ConditionModifier;
import shadows.apotheosis.spawn.modifiers.EggModifier;
import shadows.apotheosis.spawn.modifiers.MaxDelayModifier;
import shadows.apotheosis.spawn.modifiers.MinDelayModifier;
import shadows.apotheosis.spawn.modifiers.NearbyEntityModifier;
import shadows.apotheosis.spawn.modifiers.PlayerDistModifier;
import shadows.apotheosis.spawn.modifiers.PlayerModifier;
import shadows.apotheosis.spawn.modifiers.RedstoneModifier;
import shadows.apotheosis.spawn.modifiers.SpawnCountModifier;
import shadows.apotheosis.spawn.modifiers.SpawnRangeModifier;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;

public class SpawnerModifiers {
    public static final List<SpawnerModifier> MODIFIERS = new ArrayList<SpawnerModifier>();
    public static final SpawnerModifier MIN_DELAY = new MinDelayModifier();
    public static final SpawnerModifier MAX_DELAY = new MaxDelayModifier();
    public static final SpawnerModifier SPAWN_COUNT = new SpawnCountModifier();
    public static final SpawnerModifier NEARBY_ENTITIES = new NearbyEntityModifier();
    public static final SpawnerModifier PLAYER_DISTANCE = new PlayerDistModifier();
    public static final SpawnerModifier SPAWN_RANGE = new SpawnRangeModifier();
    public static final SpawnerModifier CONDITIONS = new ConditionModifier();
    public static final SpawnerModifier PLAYERS = new PlayerModifier();
    public static final SpawnerModifier CAP = new CapModifier();
    public static final SpawnerModifier REDSTONE = new RedstoneModifier();
    public static final SpawnerModifier EGG = new EggModifier();
    public static Ingredient inverseItem;

    public static void init() {
        SpawnerModifiers.register(MIN_DELAY);
        SpawnerModifiers.register(MAX_DELAY);
        SpawnerModifiers.register(SPAWN_COUNT);
        SpawnerModifiers.register(NEARBY_ENTITIES);
        SpawnerModifiers.register(PLAYER_DISTANCE);
        SpawnerModifiers.register(SPAWN_RANGE);
        SpawnerModifiers.register(CONDITIONS);
        SpawnerModifiers.register(PLAYERS);
        SpawnerModifiers.register(CAP);
        SpawnerModifiers.register(REDSTONE);
        SpawnerModifiers.register(EGG);
        inverseItem = SpawnerModifiers.readStackCfg(SpawnerModule.config.getString("Inverse Item", "general", "minecraft:quartz", "When held in the off-hand, this item makes modifiers change stats in the opposite direction."));
    }

    public static Ingredient readStackCfg(String s) {
        String[] split = s.split(":");
        Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)i)});
    }

    public static void register(SpawnerModifier modif) {
        if (MODIFIERS.contains(modif)) {
            throw new RuntimeException("Tried to register a spawner modifier, but it is already registered!");
        }
        MODIFIERS.add(modif);
        modif.load(SpawnerModule.config);
    }
}

