/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.crafting.CraftingHelper;
import shadows.apotheosis.deadly.loot.EquipmentType;

public class LootEntry
extends WeightedRandom.Item {
    protected final ItemStack stack;
    protected final EquipmentType type;

    public LootEntry(ItemStack stack, EquipmentType type, int weight) {
        super(weight);
        this.stack = stack;
        this.type = type;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public EquipmentType getType() {
        return this.type;
    }

    public static LootEntry deserialize(JsonObject obj) {
        JsonElement stack = obj.get("stack");
        JsonElement type = obj.get("type");
        JsonElement weight = obj.get("weight");
        ItemStack _stack = CraftingHelper.getItemStack((JsonObject)stack.getAsJsonObject(), (boolean)true);
        EquipmentType _type = EquipmentType.valueOf(type.getAsString().toUpperCase(Locale.ROOT));
        int _weight = weight.getAsInt();
        return new LootEntry(_stack, _type, _weight);
    }
}

