/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.asm;

import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeHooks;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixEvents;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.affix.Affixes;

public class DeadlyHooks {
    public static UUID getRealUUID(UUID uuid) {
        if (!Apotheosis.enableDeadly) {
            return uuid;
        }
        if (Access.getADM().equals(uuid)) {
            return Access.getADM();
        }
        if (Access.getASM().equals(uuid)) {
            return Access.getASM();
        }
        return uuid;
    }

    public static int getProtectionLevel(Iterable<ItemStack> stacks, DamageSource source) {
        int prot = 0;
        for (ItemStack s : stacks) {
            Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
            for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                prot += e.getKey().getProtectionLevel(e.getValue().floatValue(), source);
            }
        }
        return prot;
    }

    public static float getExtraDamageFor(ItemStack stack, CreatureAttribute type) {
        float dmg = 0.0f;
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
            dmg += e.getKey().getExtraDamageFor(e.getValue().floatValue(), type);
        }
        return dmg;
    }

    public static void onEntityDamaged(LivingEntity user, Entity target) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    target.field_70172_ad = 0;
                    int old = 0;
                    e.getKey().onEntityDamaged(user, target, e.getValue().floatValue());
                    target.field_70172_ad = old;
                }
            }
        }
    }

    public static void onUserHurt(LivingEntity user, Entity attacker) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    e.getKey().onUserHurt(user, attacker, e.getValue().floatValue());
                }
            }
        }
    }

    public static ActionResultType onItemUse(ItemStack stack, ItemUseContext ctx) {
        ActionResultType type = AffixEvents.onItemUse(ctx);
        if (type != null) {
            return type;
        }
        if (!ctx.func_195991_k().field_72995_K) {
            return ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)ctx);
        }
        return DeadlyHooks.onItemUse(stack, ctx, c -> stack.func_77973_b().func_195939_a(ctx));
    }

    public static ActionResultType onItemUse(ItemStack stack, ItemUseContext ctx, Function<ItemUseContext, ActionResultType> callback) {
        PlayerEntity playerentity = ctx.func_195999_j();
        BlockPos blockpos = ctx.func_195995_a();
        CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)ctx.func_195991_k(), blockpos, false);
        if (playerentity != null && !playerentity.field_71075_bZ.field_75099_e && !stack.func_206847_b(ctx.func_195991_k().func_205772_D(), cachedblockinfo)) {
            return ActionResultType.PASS;
        }
        Item item = stack.func_77973_b();
        ActionResultType actionresulttype = callback.apply(ctx);
        if (playerentity != null && actionresulttype == ActionResultType.SUCCESS) {
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
        }
        return actionresulttype;
    }

    public static int getEnchantability(ItemStack stack) {
        int ench = stack.getItemEnchantability();
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        if (!affixes.isEmpty()) {
            ench += affixes.getOrDefault((Object)Affixes.ENCHANTABILITY, Float.valueOf(0.0f)).intValue();
        }
        return ench;
    }

    public static class Access
    extends Item {
        public Access(Item.Properties properties) {
            super(properties);
        }

        public static UUID getADM() {
            return Item.field_111210_e;
        }

        public static UUID getASM() {
            return Item.field_185050_h;
        }
    }
}

