/*
 * Decompiled with CFR 0.152.
 */
package traverse.rockcandy.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import traverse.rockcandy.RockCandy;
import traverse.rockcandy.items.BaseUsableGem;
import traverse.rockcandy.network.PacketAutoFeed;
import traverse.rockcandy.network.RockCandyPacketHandler;
import traverse.rockcandy.proxy.ClientProxy;
import traverse.rockcandy.registry.ModItems;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="rockcandy")
public class ItemCandyGem
extends BaseUsableGem {
    public ItemCandyGem() {
        super("candy_gem", 1000);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return 4;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77952_i() != stack.func_77958_k() - 1 && playerIn.func_71024_bL().func_75121_c()) {
            playerIn.func_184598_c(handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            player.func_71024_bL().func_75122_a(5, 0.6f);
            worldIn.func_184148_a(null, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> {});
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        PlayerEntity player = RockCandy.getProxy().getPlayer();
        if (player == null) {
            return;
        }
        int slot = ItemCandyGem.findStack(new ItemStack((IItemProvider)ModItems.CANDY_GEM), player);
        ItemStack stack = player.field_71071_by.func_70301_a(slot >= 0 ? slot : 0);
        if (ClientProxy.autoFeedKey != null && ClientProxy.autoFeedKey.func_151468_f() && !stack.func_190926_b()) {
            RockCandyPacketHandler.INSTANCE.sendToServer((Object)new PacketAutoFeed(!ItemCandyGem.isAutoFeeding(stack), slot));
            player.func_146105_b((ITextComponent)new StringTextComponent("Mode Changed"), true);
        }
    }

    public static int findStack(ItemStack stack, PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemstack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !stack.func_77969_a(itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void func_77663_a(ItemStack itemStack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_201670_d()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        for (int i = 0; player.field_71071_by.func_70302_i_() > i; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != this || !(stack.func_77973_b() instanceof BaseUsableGem) || !this.isActive(stack)) continue;
            this.absorbSugar(stack, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
        }
        if (ItemCandyGem.isAutoFeeding(itemStack) && player.func_71043_e(false) && itemStack.func_77984_f() && itemStack.func_77958_k() - itemStack.func_77952_i() > 1) {
            player.func_71024_bL().func_75122_a(5, 0.6f);
            itemStack.func_222118_a(1, (LivingEntity)player, playerEntity -> {});
        }
    }

    private void absorbSugar(ItemStack rockGem, IItemHandler inventory) {
        int damage = rockGem.func_77952_i();
        if (damage != 0) {
            for (int i = 0; inventory.getSlots() > i; ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() != Items.field_151102_aT) continue;
                ItemStack sugarStack = inventory.extractItem(i, 1, false);
                this.setDamage(rockGem, damage - sugarStack.func_190916_E());
                return;
            }
        }
    }

    public static boolean isAutoFeeding(@Nonnull ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return false;
        }
        return compound.func_74767_n("autoFeed");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(stack.func_77958_k() - stack.func_77973_b().getDamage(stack) + "/" + stack.func_77958_k() + " Charges"));
        if (ItemCandyGem.isAutoFeeding(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Auto Feed: " + TextFormatting.GREEN + "Enabled"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Auto Feed: " + TextFormatting.RED + "Disabled"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

