/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp.util;

import java.util.BitSet;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import tk.dczippl.lightestlamp.Config;
import tk.dczippl.lightestlamp.init.ModBlocks;

public class WorldGenerator {
    private static final GlowstoneOreFeature GLOWSTONE = new GlowstoneOreFeature();
    private static final CountRangeConfig NEON_BLOCK = new CountRangeConfig(362, 64, 0, 128);
    private static final int NEON_BLOCK_VEINSIZE = 48;
    private static final CountRangeConfig ARGON_BLOCK = new CountRangeConfig(284, 64, 0, 128);
    private static final int ARGON_BLOCK_VEINSIZE = 48;
    private static final CountRangeConfig KRYPTON_BLOCK = new CountRangeConfig(248, 86, 0, 128);
    private static final int KRYPTON_BLOCK_VEINSIZE = 42;
    private static final CountRangeConfig BORON_BLOCK = new CountRangeConfig(129, 43, 0, 128);
    private static final int BORON_BLOCK_VEINSIZE = 3;

    public static void setupWorldGeneraton() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            if (((Boolean)Config.NEON_GLOWSTONE_SPAWN.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, GLOWSTONE.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.NEON_BLOCK.func_176223_P(), 48)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)NEON_BLOCK)));
            }
            if (((Boolean)Config.ARGON_GLOWSTONE_SPAWN.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, GLOWSTONE.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.ARGON_BLOCK.func_176223_P(), 48)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)ARGON_BLOCK)));
            }
            if (((Boolean)Config.KRYPTON_GLOWSTONE_SPAWN.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, GLOWSTONE.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.KRYPTON_BLOCK.func_176223_P(), 42)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)KRYPTON_BLOCK)));
            }
            if (!((Boolean)Config.BORON_SPAWN.get()).booleanValue()) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, OreFeature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.BORON_ORE.func_176223_P(), 3)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)BORON_BLOCK)));
        }
    }

    public static class GlowstoneOreFeature
    extends OreFeature {
        public GlowstoneOreFeature() {
            super(null);
        }

        protected boolean func_207803_a(IWorld p_207803_1_, Random p_207803_2_, OreFeatureConfig p_207803_3_, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int p_207803_16_, int p_207803_17_, int p_207803_18_, int p_207803_19_, int p_207803_20_) {
            double lvt_33_2_;
            double lvt_31_2_;
            double lvt_29_2_;
            double lvt_27_2_;
            int lvt_25_2_;
            int lvt_21_1_ = 0;
            BitSet lvt_22_1_ = new BitSet(p_207803_19_ * p_207803_20_ * p_207803_19_);
            BlockPos.Mutable lvt_23_1_ = new BlockPos.Mutable();
            double[] lvt_24_1_ = new double[p_207803_3_.field_202443_c * 4];
            for (lvt_25_2_ = 0; lvt_25_2_ < p_207803_3_.field_202443_c; ++lvt_25_2_) {
                float lvt_26_1_ = (float)lvt_25_2_ / (float)p_207803_3_.field_202443_c;
                lvt_27_2_ = MathHelper.func_219803_d((double)lvt_26_1_, (double)p_207803_4_, (double)p_207803_6_);
                lvt_29_2_ = MathHelper.func_219803_d((double)lvt_26_1_, (double)p_207803_12_, (double)p_207803_14_);
                lvt_31_2_ = MathHelper.func_219803_d((double)lvt_26_1_, (double)p_207803_8_, (double)p_207803_10_);
                lvt_33_2_ = p_207803_2_.nextDouble() * (double)p_207803_3_.field_202443_c / 16.0;
                double lvt_35_1_ = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * lvt_26_1_)) + 1.0f) * lvt_33_2_ + 1.0) / 2.0;
                lvt_24_1_[lvt_25_2_ * 4 + 0] = lvt_27_2_;
                lvt_24_1_[lvt_25_2_ * 4 + 1] = lvt_29_2_;
                lvt_24_1_[lvt_25_2_ * 4 + 2] = lvt_31_2_;
                lvt_24_1_[lvt_25_2_ * 4 + 3] = lvt_35_1_;
            }
            for (lvt_25_2_ = 0; lvt_25_2_ < p_207803_3_.field_202443_c - 1; ++lvt_25_2_) {
                if (!(lvt_24_1_[lvt_25_2_ * 4 + 3] > 0.0)) continue;
                for (int lvt_26_2_ = lvt_25_2_ + 1; lvt_26_2_ < p_207803_3_.field_202443_c; ++lvt_26_2_) {
                    if (!(lvt_24_1_[lvt_26_2_ * 4 + 3] > 0.0) || !((lvt_33_2_ = lvt_24_1_[lvt_25_2_ * 4 + 3] - lvt_24_1_[lvt_26_2_ * 4 + 3]) * lvt_33_2_ > (lvt_27_2_ = lvt_24_1_[lvt_25_2_ * 4 + 0] - lvt_24_1_[lvt_26_2_ * 4 + 0]) * lvt_27_2_ + (lvt_29_2_ = lvt_24_1_[lvt_25_2_ * 4 + 1] - lvt_24_1_[lvt_26_2_ * 4 + 1]) * lvt_29_2_ + (lvt_31_2_ = lvt_24_1_[lvt_25_2_ * 4 + 2] - lvt_24_1_[lvt_26_2_ * 4 + 2]) * lvt_31_2_)) continue;
                    if (lvt_33_2_ > 0.0) {
                        lvt_24_1_[lvt_26_2_ * 4 + 3] = -1.0;
                        continue;
                    }
                    lvt_24_1_[lvt_25_2_ * 4 + 3] = -1.0;
                }
            }
            for (lvt_25_2_ = 0; lvt_25_2_ < p_207803_3_.field_202443_c; ++lvt_25_2_) {
                double lvt_26_3_ = lvt_24_1_[lvt_25_2_ * 4 + 3];
                if (!(lvt_26_3_ >= 0.0)) continue;
                double lvt_28_1_ = lvt_24_1_[lvt_25_2_ * 4 + 0];
                double lvt_30_1_ = lvt_24_1_[lvt_25_2_ * 4 + 1];
                double lvt_32_1_ = lvt_24_1_[lvt_25_2_ * 4 + 2];
                int lvt_34_1_ = Math.max(MathHelper.func_76128_c((double)(lvt_28_1_ - lvt_26_3_)), p_207803_16_);
                int lvt_35_2_ = Math.max(MathHelper.func_76128_c((double)(lvt_30_1_ - lvt_26_3_)), p_207803_17_);
                int lvt_36_1_ = Math.max(MathHelper.func_76128_c((double)(lvt_32_1_ - lvt_26_3_)), p_207803_18_);
                int lvt_37_1_ = Math.max(MathHelper.func_76128_c((double)(lvt_28_1_ + lvt_26_3_)), lvt_34_1_);
                int lvt_38_1_ = Math.max(MathHelper.func_76128_c((double)(lvt_30_1_ + lvt_26_3_)), lvt_35_2_);
                int lvt_39_1_ = Math.max(MathHelper.func_76128_c((double)(lvt_32_1_ + lvt_26_3_)), lvt_36_1_);
                for (int lvt_40_1_ = lvt_34_1_; lvt_40_1_ <= lvt_37_1_; ++lvt_40_1_) {
                    double lvt_41_1_ = ((double)lvt_40_1_ + 0.5 - lvt_28_1_) / lvt_26_3_;
                    if (!(lvt_41_1_ * lvt_41_1_ < 1.0)) continue;
                    for (int lvt_43_1_ = lvt_35_2_; lvt_43_1_ <= lvt_38_1_; ++lvt_43_1_) {
                        double lvt_44_1_ = ((double)lvt_43_1_ + 0.5 - lvt_30_1_) / lvt_26_3_;
                        if (!(lvt_41_1_ * lvt_41_1_ + lvt_44_1_ * lvt_44_1_ < 1.0)) continue;
                        for (int lvt_46_1_ = lvt_36_1_; lvt_46_1_ <= lvt_39_1_; ++lvt_46_1_) {
                            int lvt_49_1_;
                            double lvt_47_1_ = ((double)lvt_46_1_ + 0.5 - lvt_32_1_) / lvt_26_3_;
                            if (!(lvt_41_1_ * lvt_41_1_ + lvt_44_1_ * lvt_44_1_ + lvt_47_1_ * lvt_47_1_ < 1.0) || lvt_22_1_.get(lvt_49_1_ = lvt_40_1_ - p_207803_16_ + (lvt_43_1_ - p_207803_17_) * p_207803_19_ + (lvt_46_1_ - p_207803_18_) * p_207803_19_ * p_207803_20_)) continue;
                            lvt_22_1_.set(lvt_49_1_);
                            lvt_23_1_.func_181079_c(lvt_40_1_, lvt_43_1_, lvt_46_1_);
                            if (p_207803_1_.func_180495_p((BlockPos)lvt_23_1_).func_177230_c() != Blocks.field_150426_aN) continue;
                            p_207803_1_.func_180501_a((BlockPos)lvt_23_1_, p_207803_3_.field_202444_d, 2);
                            ++lvt_21_1_;
                        }
                    }
                }
            }
            return lvt_21_1_ > 0;
        }
    }
}

