/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.defaultoptions.CommandDefaultOptions;
import net.blay09.mods.defaultoptions.DefaultBinding;
import net.blay09.mods.defaultoptions.DefaultOptionsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.CommandSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="defaultoptions")
public class DefaultOptions {
    public static final String MOD_ID = "defaultoptions";
    public static final Logger logger = LogManager.getLogger((String)"defaultoptions");
    private static Map<String, DefaultBinding> defaultKeys = Maps.newHashMap();
    private static List<String> knownKeys = Lists.newArrayList();
    private static final Pattern KEY_PATTERN = Pattern.compile("key_([^:]+):([^:]+)(?::(.+))?");

    public DefaultOptions() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            DefaultOptions.applyDefaults();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::finishLoading);
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DefaultOptionsConfig.commonSpec);
        MinecraftForge.EVENT_BUS.addListener(this::setupServer);
    }

    private void setupServer(FMLServerStartingEvent event) {
        CommandDefaultOptions.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public static void applyDefaults() {
        File serversDatFile;
        File optionsFileOF;
        boolean firstRun;
        File mcDataDir = DefaultOptions.getMinecraftDataDir();
        File optionsFile = new File(mcDataDir, "options.txt");
        boolean bl = firstRun = !optionsFile.exists();
        if (firstRun) {
            DefaultOptions.applyDefaultOptions();
        }
        if (!(optionsFileOF = new File(mcDataDir, "optionsof.txt")).exists()) {
            DefaultOptions.applyDefaultOptionsOptifine();
        }
        if (!(serversDatFile = new File(mcDataDir, "servers.dat")).exists()) {
            DefaultOptions.applyDefaultServers();
        }
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(() -> {
            File defaultKeybindings;
            File defaultOptionsOF;
            File defaultOptions = new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt");
            if (!defaultOptions.exists()) {
                DefaultOptions.saveDefaultOptions();
            }
            if (!(defaultOptionsOF = new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt")).exists()) {
                DefaultOptions.saveDefaultOptionsOptifine();
            }
            if (!(defaultKeybindings = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")).exists()) {
                DefaultOptions.saveDefaultMappings();
            }
            DefaultOptions.reloadDefaultMappings();
        });
    }

    private static void applyDefaultServers() {
        try {
            FileUtils.copyFile((File)new File(DefaultOptions.getDefaultOptionsFolder(), "servers.dat"), (File)new File(DefaultOptions.getMinecraftDataDir(), "servers.dat"));
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private static boolean applyDefaultOptions() {
        File defaultOptionsFile = new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getMinecraftDataDir(), "options.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void applyDefaultOptionsOptifine() {
        File defaultOptionsFile = new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getMinecraftDataDir(), "optionsof.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean saveDefaultOptionsOptifine() {
        if (!ModList.get().isLoaded("optifine")) {
            return true;
        }
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(DefaultOptions.getMinecraftDataDir(), "optionsof.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveDefaultOptions() {
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(DefaultOptions.getMinecraftDataDir(), "options.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveDefaultServers() {
        File serversDat = new File(DefaultOptions.getMinecraftDataDir(), "servers.dat");
        if (serversDat.exists()) {
            try {
                FileUtils.copyFile((File)serversDat, (File)new File(DefaultOptions.getDefaultOptionsFolder(), "servers.dat"));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean saveDefaultMappings() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                writer.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m() + ":" + keyBinding.getKeyModifier().name());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void reloadDefaultMappings() {
        File knownKeysFile;
        block51: {
            defaultKeys.clear();
            knownKeys.clear();
            File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
            if (defaultKeysFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    Throwable throwable = null;
                    block35: while (true) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Matcher matcher;
                                if (line.isEmpty() || !(matcher = KEY_PATTERN.matcher(line)).matches()) continue;
                                try {
                                    KeyModifier modifier = matcher.group(3) != null ? KeyModifier.valueFromString((String)matcher.group(3)) : KeyModifier.NONE;
                                    defaultKeys.put(matcher.group(1), new DefaultBinding(InputMappings.func_197955_a((String)matcher.group(2)), modifier));
                                    continue block35;
                                }
                                catch (Exception e) {
                                    logger.error("Error loading default key binding for {}", (Object)line, (Object)e);
                                }
                            }
                            break block51;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Error loading default key bindings", (Throwable)e);
                }
            }
        }
        if ((knownKeysFile = new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")).exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(knownKeysFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    knownKeys.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!defaultKeys.containsKey(keyBinding.func_151464_g())) continue;
            DefaultBinding defaultBinding = defaultKeys.get(keyBinding.func_151464_g());
            keyBinding.field_151472_e = defaultBinding.input;
            ObfuscationReflectionHelper.setPrivateValue(KeyBinding.class, (Object)keyBinding, (Object)defaultBinding.modifier, (String)"keyModifierDefault");
            if (knownKeys.contains(keyBinding.func_151464_g())) continue;
            keyBinding.setKeyModifierAndCode(keyBinding.getKeyModifierDefault(), keyBinding.func_197977_i());
            knownKeys.add(keyBinding.func_151464_g());
        }
        KeyBinding.func_74508_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")));){
            for (String key : knownKeys) {
                writer.println(key);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getDefaultOptionsFolder() {
        File defaultOptions = new File(DefaultOptions.getMinecraftDataDir(), "config/defaultoptions");
        if (!defaultOptions.exists() && !defaultOptions.mkdirs()) {
            throw new IllegalStateException("Could not create default options directory.");
        }
        return defaultOptions;
    }

    public static File getMinecraftDataDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }
}

