/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class SpawnerBuilder {
    public static final String SPAWN_DELAY = "Delay";
    public static final String SPAWN_POTENTIALS = "SpawnPotentials";
    public static final String SPAWN_DATA = "SpawnData";
    public static final String MIN_SPAWN_DELAY = "MinSpawnDelay";
    public static final String MAX_SPAWN_DELAY = "MaxSpawnDelay";
    public static final String SPAWN_COUNT = "SpawnCount";
    public static final String MAX_NEARBY_ENTITIES = "MaxNearbyEntities";
    public static final String REQUIRED_PLAYER_RANGE = "RequiredPlayerRange";
    public static final String SPAWN_RANGE = "SpawnRange";
    public static final String ID = "id";
    public static final String ENTITY = "Entity";
    public static final CompoundNBT BASE_TAG;
    CompoundNBT tag = BASE_TAG.func_74737_b();
    boolean hasPotentials = false;
    WeightedSpawnerEntity baseEntity = new WeightedSpawnerEntity();

    public SpawnerBuilder() {
        this.tag.func_218657_a(SPAWN_DATA, (INBT)this.baseEntity.func_185277_b());
    }

    public SpawnerBuilder setType(EntityType<? extends Entity> entity) {
        return this.setType(entity.getRegistryName());
    }

    public SpawnerBuilder setType(ResourceLocation entity) {
        this.baseEntity.func_185277_b().func_74778_a(ID, entity.toString());
        return this;
    }

    public SpawnerBuilder setDelay(int delay) {
        this.tag.func_74777_a(SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMinDelay(int delay) {
        this.tag.func_74777_a(MIN_SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMaxDelay(int delay) {
        this.tag.func_74777_a(MAX_SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMinAndMaxDelay(int min, int max) {
        this.setMinDelay(min);
        this.setMaxDelay(max);
        return this;
    }

    public SpawnerBuilder setSpawnCount(int count) {
        this.tag.func_74777_a(SPAWN_COUNT, (short)count);
        return this;
    }

    public SpawnerBuilder setMaxNearbyEntities(int max) {
        this.tag.func_74777_a(MAX_NEARBY_ENTITIES, (short)max);
        return this;
    }

    public SpawnerBuilder setPlayerRange(int range) {
        this.tag.func_74777_a(REQUIRED_PLAYER_RANGE, (short)range);
        return this;
    }

    public SpawnerBuilder setSpawnRange(int range) {
        this.tag.func_74777_a(SPAWN_RANGE, (short)range);
        return this;
    }

    public SpawnerBuilder setSpawnData(CompoundNBT data) {
        if (data == null) {
            data = new CompoundNBT();
            data.func_74778_a(ID, "minecraft:pig");
        }
        this.baseEntity.field_185279_b = data.func_74737_b();
        return this;
    }

    public SpawnerBuilder setPotentials(WeightedSpawnerEntity ... entries) {
        this.hasPotentials = true;
        this.tag.func_218657_a(SPAWN_POTENTIALS, (INBT)new ListNBT());
        ListNBT list = this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
        for (WeightedSpawnerEntity e : entries) {
            list.add((Object)e.func_185278_a());
        }
        return this;
    }

    public SpawnerBuilder addPotentials(WeightedSpawnerEntity ... entries) {
        this.hasPotentials = true;
        ListNBT list = this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
        for (WeightedSpawnerEntity e : entries) {
            list.add((Object)e.func_185278_a());
        }
        return this;
    }

    public CompoundNBT getSpawnData() {
        return this.tag.func_74775_l(SPAWN_DATA);
    }

    public ListNBT getPotentials() {
        return this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
    }

    public void build(IWorld world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        }
        TileEntity s = world.func_175625_s(pos);
        s.func_145839_a(this.tag);
        s.func_174878_a(pos);
    }

    static {
        MobSpawnerTileEntity te = (MobSpawnerTileEntity)Blocks.field_150474_ac.createTileEntity(null, null);
        te.func_145881_a().func_200876_a(EntityType.field_200784_X);
        BASE_TAG = te.func_189515_b(new CompoundNBT());
        BASE_TAG.func_150295_c(SPAWN_POTENTIALS, 10).clear();
    }
}

