/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.upgrade;

import java.util.Arrays;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.upgrade.IUpgradeHolder;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class UpgradeCache {
    private final int[] upgradeCount = new int[EnumUpgrade.values().length];
    private final IUpgradeHolder holder;
    private boolean isValid = false;
    private Direction ejectDirection;

    public UpgradeCache(IUpgradeHolder holder) {
        this.holder = holder;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public int getUpgrades(EnumUpgrade type) {
        this.validate();
        return this.upgradeCount[type.ordinal()];
    }

    public Direction getEjectDirection() {
        return this.ejectDirection;
    }

    public void validate() {
        if (this.isValid) {
            return;
        }
        IItemHandler handler = this.holder.getUpgradeHandler();
        Arrays.fill(this.upgradeCount, 0);
        this.ejectDirection = null;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_77973_b() instanceof ItemMachineUpgrade) {
                ItemMachineUpgrade upgrade = ItemMachineUpgrade.of(stack);
                EnumUpgrade type = upgrade.getUpgradeType();
                if (this.upgradeCount[type.ordinal()] != 0) {
                    Log.warning("found upgrade " + (Object)((Object)type) + " in multiple slots! Ignoring.", new Object[0]);
                    continue;
                }
                this.upgradeCount[type.ordinal()] = stack.func_190916_E() * upgrade.getTier();
                this.handleExtraData(stack, type);
                continue;
            }
            if (stack.func_190926_b()) continue;
            throw new IllegalStateException("found non-upgrade item in an upgrade handler! " + stack);
        }
        this.isValid = true;
        this.holder.onUpgradesChanged();
    }

    private void handleExtraData(ItemStack stack, EnumUpgrade type) {
        if (type == EnumUpgrade.DISPENSER && stack.func_77942_o()) {
            this.ejectDirection = Direction.func_176739_a((String)NBTUtil.getString(stack, "Facing"));
        }
    }

    public IntArrayNBT toNBT() {
        this.validate();
        return new IntArrayNBT(this.upgradeCount);
    }
}

