/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;

public class ChunkCache
implements ICollisionReader {
    protected final int chunkX;
    protected final int chunkZ;
    protected final IChunk[][] chunks;
    protected boolean empty;
    protected final World world;

    public ChunkCache(World worldIn, BlockPos pos1, BlockPos pos2) {
        int z;
        int x;
        this.world = worldIn;
        this.chunkX = pos1.func_177958_n() >> 4;
        this.chunkZ = pos1.func_177952_p() >> 4;
        int endX = pos2.func_177958_n() >> 4;
        int endZ = pos2.func_177952_p() >> 4;
        this.chunks = new IChunk[endX - this.chunkX + 1][endZ - this.chunkZ + 1];
        this.empty = true;
        for (x = this.chunkX; x <= endX; ++x) {
            for (z = this.chunkZ; z <= endZ; ++z) {
                this.chunks[x - this.chunkX][z - this.chunkZ] = this.world.func_217353_a(x, z, ChunkStatus.field_222617_m, true);
            }
        }
        for (x = pos1.func_177958_n() >> 4; x <= pos2.func_177958_n() >> 4; ++x) {
            for (z = pos1.func_177952_p() >> 4; z <= pos2.func_177952_p() >> 4; ++z) {
                IChunk ichunk = this.chunks[x - this.chunkX][z - this.chunkZ];
                if (ichunk == null || ichunk.func_76606_c(pos1.func_177956_o(), pos2.func_177956_o())) continue;
                this.empty = false;
                return;
            }
        }
    }

    private IChunk getChunk(BlockPos pos) {
        return this.getChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    private IChunk getChunk(int chunkX, int chunkZ) {
        int x = chunkX - this.chunkX;
        int z = chunkZ - this.chunkZ;
        if (x >= 0 && x < this.chunks.length && z >= 0 && z < this.chunks[x].length) {
            IChunk ichunk = this.chunks[x][z];
            return ichunk != null ? ichunk : new EmptyChunk(this.world, new ChunkPos(chunkX, chunkZ));
        }
        return new EmptyChunk(this.world, new ChunkPos(chunkX, chunkZ));
    }

    public WorldBorder func_175723_af() {
        return this.world.func_175723_af();
    }

    public IBlockReader func_225522_c_(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IChunk ichunk = this.getChunk(pos);
        return ichunk.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        IChunk ichunk = this.getChunk(pos);
        return ichunk.func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        IChunk ichunk = this.getChunk(pos);
        return ichunk.func_204610_c(pos);
    }
}

