/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityOmnidirectionalHopper
extends TileEntityAbstractHopper {
    public static final int INVENTORY_SIZE = 5;
    private final ComparatorItemStackHandler itemHandler = new ComparatorItemStackHandler(this, this.getInvSize());
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.itemHandler);

    public TileEntityOmnidirectionalHopper() {
        super((TileEntityType)ModTileEntities.OMNIDIRECTIONAL_HOPPER.get());
    }

    protected int getInvSize() {
        return 5;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    protected int getComparatorValueInternal() {
        return this.itemHandler.getComparatorValue();
    }

    @Override
    protected boolean doExport(int maxItems) {
        Direction outputDir = this.getRotation();
        LazyOptional<IItemHandler> cap = IOHelper.getInventoryForTE(this.getCachedNeighbor(outputDir), outputDir.func_176734_d());
        if (cap.isPresent()) {
            return (Boolean)cap.map(otherHandler -> {
                int max = maxItems;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.func_190916_E() <= this.leaveMaterialCount) continue;
                    ItemStack exportedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(maxItems, stack.func_190916_E() - this.leaveMaterialCount));
                    int toExport = exportedStack.func_190916_E();
                    ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)exportedStack, (boolean)false);
                    int exportedCount = toExport - excess.func_190916_E();
                    if (!this.isCreative) {
                        stack.func_190918_g(exportedCount);
                        if (exportedCount > 0) {
                            this.itemHandler.invalidateComparatorValue();
                        }
                    }
                    if ((max -= exportedCount) > 0) continue;
                    return true;
                }
                return false;
            }).orElse((Object)false);
        }
        if (PNCConfig.Common.Machines.omniHopperDispenser && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            BlockPos pos = this.func_174877_v().func_177972_a(outputDir);
            int remaining = maxItems;
            if (!Block.func_220056_d((BlockState)this.field_145850_b.func_180495_p(pos), (IBlockReader)this.field_145850_b, (BlockPos)pos, (Direction)outputDir.func_176734_d())) {
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    ItemStack inSlot = this.itemHandler.getStackInSlot(i);
                    ItemStack stack = this.itemHandler.extractItem(i, Math.min(inSlot.func_190916_E() - this.leaveMaterialCount, remaining), this.isCreative);
                    if (stack.func_190926_b()) continue;
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    if ((remaining -= stack.func_190916_E()) > 0) continue;
                    return true;
                }
            }
            return remaining < maxItems;
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        boolean success = false;
        if (this.isInventoryFull()) {
            return false;
        }
        Direction inputDir = this.getInputDirection();
        LazyOptional<IItemHandler> cap = IOHelper.getInventoryForTE(this.getCachedNeighbor(inputDir), inputDir.func_176734_d());
        if (cap.isPresent()) {
            return (Boolean)cap.map(otherHandler -> {
                int remaining = maxItems;
                for (int i = 0; i < otherHandler.getSlots(); ++i) {
                    if (otherHandler.getStackInSlot(i).func_190926_b()) continue;
                    ItemStack toExtract = otherHandler.extractItem(i, remaining, true);
                    ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)toExtract, (boolean)false);
                    int transferred = toExtract.func_190916_E() - excess.func_190916_E();
                    if (transferred <= 0) continue;
                    otherHandler.extractItem(i, transferred, false);
                    if ((remaining -= transferred) > 0) continue;
                    return true;
                }
                return remaining < maxItems;
            }).orElse((Object)false);
        }
        for (ItemEntity entity : TileEntityOmnidirectionalHopper.getNeighborItems(this, inputDir)) {
            ItemStack remainder = IOHelper.insert(this, entity.func_92059_d(), null, false);
            if (remainder.func_190926_b()) {
                entity.func_70106_y();
                success = true;
                continue;
            }
            if (remainder.func_190916_E() >= entity.func_92059_d().func_190916_E()) continue;
            entity.func_92058_a(remainder);
            success = true;
        }
        return success;
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerOmnidirectionalHopper(i, playerInventory, this.func_174877_v());
    }
}

