/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityAssemblyRobot
extends TileEntityTickableBase
implements IAssemblyMachine,
IResettable {
    public final float[] oldAngles = new float[5];
    @DescSynced
    @LazySynced
    public final float[] angles = new float[5];
    @DescSynced
    final float[] targetAngles = new float[5];
    Direction[] targetDirection = new Direction[]{null, null};
    @DescSynced
    boolean slowMode;
    @DescSynced
    protected float speed = 1.0f;
    private BlockPos controllerPos;

    TileEntityAssemblyRobot(TileEntityType type) {
        super(type);
        this.gotoHomePosition();
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = this.targetAngles[i];
            this.oldAngles[i] = this.targetAngles[i];
        }
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.invalidateSystem();
    }

    void invalidateSystem() {
        TileEntity te;
        if (this.controllerPos != null && (te = this.func_145831_w().func_175625_s(this.controllerPos)) instanceof TileEntityAssemblyController) {
            ((TileEntityAssemblyController)te).invalidateAssemblySystem();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        System.arraycopy(this.angles, 0, this.oldAngles, 0, 5);
        for (int i = 0; i < 5; ++i) {
            if (this.angles[i] > this.targetAngles[i]) {
                this.angles[i] = Math.max(this.angles[i] - 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
                continue;
            }
            if (!(this.angles[i] < this.targetAngles[i])) continue;
            this.angles[i] = Math.min(this.angles[i] + 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
        }
    }

    public void gotoHomePosition() {
        this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.BASE.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.MIDDLE.ordinal()] = 55.0f;
        this.targetAngles[EnumAngles.TAIL.ordinal()] = 35.0f;
        this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
    }

    boolean gotoTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        this.gotoNeighbour(this.targetDirection[0], this.targetDirection[1]);
        return this.isDoneMoving();
    }

    public void gotoNeighbour(Direction direction) {
        this.gotoNeighbour(direction, null);
    }

    public boolean gotoNeighbour(Direction primaryDir, Direction secondaryDir) {
        this.targetDirection = new Direction[]{primaryDir, secondaryDir};
        boolean diagonal = true;
        boolean diagonalAllowed = this.canMoveToDiagonalNeighbours();
        switch (primaryDir) {
            case SOUTH: {
                if (secondaryDir == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                if (secondaryDir == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case EAST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = -90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
                break;
            }
            case NORTH: {
                if (secondaryDir == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                if (secondaryDir == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 180.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case WEST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = 90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
            }
        }
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -85.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -20.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -10.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 0.0f;
        }
        return diagonal;
    }

    boolean hoverOverTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        return this.hoverOverNeighbour(this.targetDirection);
    }

    private boolean hoverOverNeighbour(Direction[] directions) {
        this.hoverOverNeighbour(directions[0], directions[1]);
        return this.isDoneMoving();
    }

    void hoverOverNeighbour(Direction primaryDir, Direction secondaryDir) {
        boolean diagonal = this.gotoNeighbour(primaryDir, secondaryDir);
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -95.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -10.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -20.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 10.0f;
        }
    }

    TileEntity getTileEntityForCurrentDirection() {
        return this.getTileEntityForDirection(this.targetDirection[0], this.targetDirection[1]);
    }

    public TileEntity getTileEntityForDirection(Direction[] directions) {
        return this.getTileEntityForDirection(directions[0], directions[1]);
    }

    private TileEntity getTileEntityForDirection(Direction firstDir, Direction secondDir) {
        BlockPos pos = this.func_174877_v().func_177972_a(firstDir);
        return this.func_145831_w().func_175625_s(secondDir == null ? pos : pos.func_177972_a(secondDir));
    }

    boolean isDoneMoving() {
        for (int i = 0; i < 5; ++i) {
            if (PneumaticCraftUtils.areFloatsEqual(this.angles[i], this.targetAngles[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDoneRotatingYaw() {
        return PneumaticCraftUtils.areFloatsEqual(this.angles[EnumAngles.TURN.ordinal()], this.targetAngles[EnumAngles.TURN.ordinal()]);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = tag.func_74760_g("angle" + i);
            this.targetAngles[i] = tag.func_74760_g("targetAngle" + i);
        }
        this.slowMode = tag.func_74767_n("slowMode");
        this.speed = tag.func_74760_g("speed");
        this.targetDirection[0] = tag.func_74764_b("targetDir1") ? Direction.field_199792_n[tag.func_74762_e("targetDir1")] : null;
        this.targetDirection[1] = tag.func_74764_b("targetDir2") ? Direction.field_199792_n[tag.func_74762_e("targetDir2")] : null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 5; ++i) {
            tag.func_74776_a("angle" + i, this.angles[i]);
            tag.func_74776_a("targetAngle" + i, this.targetAngles[i]);
        }
        tag.func_74757_a("slowMode", this.slowMode);
        tag.func_74776_a("speed", this.speed);
        if (this.targetDirection != null) {
            if (this.targetDirection[0] != null) {
                tag.func_74768_a("targetDir1", this.targetDirection[0].ordinal());
            }
            if (this.targetDirection[1] != null) {
                tag.func_74768_a("targetDir2", this.targetDirection[1].ordinal());
            }
        }
        return tag;
    }

    public abstract boolean canMoveToDiagonalNeighbours();

    Direction[] getPlatformDirection() {
        for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
            if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir)) instanceof TileEntityAssemblyPlatform)) continue;
            return new Direction[]{dir, null};
        }
        if (this.canMoveToDiagonalNeighbours()) {
            for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                    if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir)) instanceof TileEntityAssemblyPlatform)) continue;
                    return new Direction[]{primDir, secDir};
                }
            }
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    protected static enum EnumAngles {
        TURN,
        BASE,
        MIDDLE,
        TAIL,
        HEAD;

    }
}

