/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.commons.lang3.Validate;

public class SideConfigurator<T>
implements INBTSerializable<CompoundNBT> {
    private static final String baseButtonTag = "SideConf";
    private final List<ConnectionEntry<T>> entries = new ArrayList<ConnectionEntry<T>>();
    private final String id;
    private final ISideConfigurable sideConfigurable;
    private final Map<String, Integer> idxMap = new HashMap<String, Integer>();
    private NonNullSupplier<T> nullFaceHandler;
    private final LazyOptional<T> nullFaceCap = LazyOptional.of(this.nullFaceHandler);
    private final byte[] faces = new byte[RelativeFace.values().length];
    private final byte[] defaultFaces = new byte[RelativeFace.values().length];
    private final RelativeFace[][] facingMatrix = new RelativeFace[4][];

    SideConfigurator(String id, ISideConfigurable sideConfigurable) {
        this.id = id;
        this.sideConfigurable = sideConfigurable;
        this.entries.add(null);
        this.setupFacingMatrix();
    }

    public int registerHandler(String id, ItemStack textureStack, Capability<T> cap, NonNullSupplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry(id, textureStack, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public int registerHandler(String id, ResourceLocation texture, Capability<T> cap, NonNullSupplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry(id, texture, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public void unregisterHandlers(Predicate<String> idMatcher) {
        ArrayList<ConnectionEntry<T>> newEntries = new ArrayList<ConnectionEntry<T>>();
        for (String id : this.idxMap.keySet()) {
            if (idMatcher.test(id)) continue;
            newEntries.add(this.entries.get(this.idxMap.get(id)));
        }
        this.entries.clear();
        this.entries.addAll(newEntries);
        this.idxMap.clear();
        for (int i = 0; i < this.entries.size(); ++i) {
            ConnectionEntry<T> e = this.entries.get(i);
            this.idxMap.put(((ConnectionEntry)e).id, i);
        }
    }

    private int setDefaultSides(RelativeFace ... defaultRelativeFaces) {
        Validate.isTrue((this.entries.size() <= 127 ? 1 : 0) != 0, (String)"No more than 127 entries allowed", (Object[])new Object[0]);
        byte idx = (byte)(this.entries.size() - 1);
        for (RelativeFace relativeFace : defaultRelativeFaces) {
            this.faces[relativeFace.ordinal()] = idx;
            this.defaultFaces[relativeFace.ordinal()] = idx;
        }
        return idx;
    }

    void setNullFaceHandler(String id) {
        this.nullFaceHandler = ((ConnectionEntry)this.entries.get(this.idxMap.get(id))).handler;
    }

    private boolean shouldSaveNBT() {
        return !Arrays.equals(this.faces, this.defaultFaces);
    }

    void updateHandler(String id, NonNullSupplier<T> handler) {
        int idx = this.idxMap.get(id);
        ConnectionEntry<T> e = this.entries.get(idx);
        this.entries.set(idx, new ConnectionEntry(((ConnectionEntry)e).id, ((ConnectionEntry)e).texture, ((ConnectionEntry)e).cap, handler));
        this.setNullFaceHandler(id);
    }

    public byte[] getFaces() {
        return this.faces;
    }

    public void setFaces(byte[] faces) {
        System.arraycopy(faces, 0, this.faces, 0, this.faces.length);
    }

    public boolean handleButtonPress(String tag) {
        try {
            RelativeFace relativeFace = RelativeFace.valueOf(tag.split("\\.")[1]);
            this.cycleValue(relativeFace);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getButtonId(RelativeFace relativeFace) {
        return "SideConf." + relativeFace.toString();
    }

    private void cycleValue(RelativeFace relativeFace) {
        int idx = relativeFace.ordinal();
        int n = 0;
        while (n++ < this.entries.size()) {
            ConnectionEntry<T> c;
            int n2 = idx;
            this.faces[n2] = (byte)(this.faces[n2] + 1);
            if (this.faces[idx] >= this.entries.size()) {
                this.faces[idx] = 0;
            }
            if (!this.sideConfigurable.isValid(relativeFace, (c = this.entries.get(this.faces[idx])) == null ? null : ((ConnectionEntry)c).cap)) continue;
            return;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getTranslationKey() {
        return "gui.sideConfigurator.title." + this.id;
    }

    LazyOptional<T> getHandler(Direction facing) {
        if (facing == null) {
            return this.nullFaceCap;
        }
        ConnectionEntry<T> c = this.entries.get(this.faces[this.getRelativeFace(facing).ordinal()]);
        return c == null ? LazyOptional.empty() : ((ConnectionEntry)c).lazy;
    }

    void setupFacingMatrix() {
        for (Direction f : PneumaticCraftUtils.HORIZONTALS) {
            this.facingMatrix[f.func_176736_b()] = new RelativeFace[4];
            for (RelativeFace rf : RelativeFace.HORIZONTALS) {
                Direction f2 = this.rot(f, rf);
                this.facingMatrix[f.func_176736_b()][f2.func_176736_b()] = rf;
            }
        }
    }

    private Direction rot(Direction in, RelativeFace rf) {
        switch (rf) {
            case RIGHT: {
                return in.func_176735_f();
            }
            case LEFT: {
                return in.func_176746_e();
            }
            case BACK: {
                return in.func_176734_d();
            }
        }
        return in;
    }

    private RelativeFace getRelativeFace(Direction facing) {
        if (facing == Direction.UP) {
            return RelativeFace.TOP;
        }
        if (facing == Direction.DOWN) {
            return RelativeFace.BOTTOM;
        }
        return this.facingMatrix[this.sideConfigurable.byIndex().func_176736_b()][facing.func_176736_b()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupButton(WidgetButtonExtended button) {
        try {
            RelativeFace relativeFace = RelativeFace.valueOf(button.getTag().split("\\.")[1]);
            ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
            if (c != null) {
                if (((ConnectionEntry)c).texture instanceof ItemStack) {
                    button.setRenderStacks((ItemStack)((ConnectionEntry)c).texture);
                    button.setRenderedIcon(null);
                } else if (((ConnectionEntry)c).texture instanceof ResourceLocation) {
                    button.setRenderStacks(ItemStack.field_190927_a);
                    button.setRenderedIcon((ResourceLocation)((ConnectionEntry)c).texture);
                }
            } else {
                button.setRenderStacks(ItemStack.field_190927_a);
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
            }
            button.setTooltipText((List<String>)ImmutableList.of((Object)(TextFormatting.YELLOW + relativeFace.toString()), (Object)I18n.func_135052_a((String)this.getFaceKey(relativeFace), (Object[])new Object[0])));
        }
        catch (IllegalArgumentException e) {
            Log.warning("Bad tag '" + button.getTag() + "'", new Object[0]);
        }
    }

    private String getFaceKey(RelativeFace relativeFace) {
        ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
        return c == null ? "gui.sideConfigurator.unconnected" : "gui.sideConfigurator." + this.id + "." + ((ConnectionEntry)c).id;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT l = new ListNBT();
        for (byte face : this.faces) {
            l.add((Object)ByteNBT.func_229671_a_((byte)face));
        }
        tag.func_218657_a("faces", (INBT)l);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT l = nbt.func_150295_c("faces", 1);
        for (int i = 0; i < l.size() && i < this.faces.length; ++i) {
            this.faces[i] = ((ByteNBT)l.get(i)).func_150290_f();
        }
    }

    public static CompoundNBT writeToNBT(ISideConfigurable sideConfigurable) {
        CompoundNBT tag = new CompoundNBT();
        for (SideConfigurator sc : sideConfigurable.getSideConfigurators()) {
            if (!sc.shouldSaveNBT()) continue;
            CompoundNBT subtag = sc.serializeNBT();
            tag.func_218657_a(sc.id, (INBT)subtag);
        }
        return tag;
    }

    public static void readFromNBT(CompoundNBT tag, ISideConfigurable sideConfigurable) {
        for (SideConfigurator sc : sideConfigurable.getSideConfigurators()) {
            if (!tag.func_74764_b(sc.id)) continue;
            CompoundNBT subtag = tag.func_74775_l(sc.id);
            sc.deserializeNBT(subtag);
        }
    }

    private static class ConnectionEntry<T> {
        private final String id;
        private final Object texture;
        private final Capability<T> cap;
        private final NonNullSupplier<T> handler;
        private final LazyOptional<T> lazy;

        private ConnectionEntry(String id, Object texture, Capability<T> cap, NonNullSupplier<T> handler) {
            this.id = id;
            this.texture = texture;
            this.cap = cap;
            this.handler = handler;
            this.lazy = LazyOptional.of(handler);
        }
    }

    public static enum RelativeFace {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT,
        FRONT,
        BACK;

        public static final RelativeFace[] HORIZONTALS;

        static {
            HORIZONTALS = new RelativeFace[4];
            RelativeFace.HORIZONTALS[0] = LEFT;
            RelativeFace.HORIZONTALS[1] = RIGHT;
            RelativeFace.HORIZONTALS[2] = FRONT;
            RelativeFace.HORIZONTALS[3] = BACK;
        }
    }
}

