/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class JEIAmadronTradeCategory
implements IRecipeCategory<AmadronOffer> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.AMADRON_TABLET.get()));

    JEIAmadronTradeCategory() {
        this.background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.WIDGET_AMADRON_OFFER, 0, 0, 73, 35);
        this.localizedName = I18n.func_135052_a((String)((ItemAmadronTablet)ModItems.AMADRON_TABLET.get()).func_77658_a(), (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.AMADRON_TRADE;
    }

    public Class<? extends AmadronOffer> getRecipeClass() {
        return AmadronOffer.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AmadronOffer recipe, IIngredients ingredients) {
        if (recipe.getInput().getType() == AmadronTradeResource.Type.ITEM) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput().getItem());
        } else if (recipe.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getInput().getFluid());
        }
        if (recipe.getOutput().getType() == AmadronTradeResource.Type.ITEM) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput().getItem());
        } else if (recipe.getOutput().getType() == AmadronTradeResource.Type.FLUID) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput().getFluid());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, AmadronOffer recipe, IIngredients ingredients) {
        if (recipe.getInput().getType() == AmadronTradeResource.Type.ITEM) {
            recipeLayout.getItemStacks().init(0, true, 5, 14);
            recipeLayout.getItemStacks().set(0, recipe.getInput().getItem());
        } else if (recipe.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            recipeLayout.getFluidStacks().init(0, true, 6, 15, 16, 16, 1000, false, (IDrawable)new FluidTextOverlay(recipe.getInput().getFluid()));
            recipeLayout.getFluidStacks().set(0, recipe.getInput().getFluid());
        }
        if (recipe.getOutput().getType() == AmadronTradeResource.Type.ITEM) {
            recipeLayout.getItemStacks().init(1, false, 50, 14);
            recipeLayout.getItemStacks().set(1, recipe.getOutput().getItem());
        } else if (recipe.getOutput().getType() == AmadronTradeResource.Type.FLUID) {
            recipeLayout.getFluidStacks().init(1, false, 51, 15, 16, 16, 1000, false, (IDrawable)new FluidTextOverlay(recipe.getOutput().getFluid()));
            recipeLayout.getFluidStacks().set(1, recipe.getOutput().getFluid());
        }
    }

    public void draw(AmadronOffer recipe, double mouseX, double mouseY) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = (this.background.getWidth() - fr.func_78256_a(recipe.getVendor())) / 2;
        fr.func_211126_b(recipe.getVendor(), (float)x, 3.0f, -12566464);
    }

    public List<String> getTooltipStrings(AmadronOffer recipe, double mouseX, double mouseY) {
        ArrayList<String> res = new ArrayList<String>();
        if (mouseX >= 22.0 && mouseX <= 51.0 && mouseY >= 12.0) {
            res.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.vendor", (Object[])new Object[]{recipe.getVendor()}));
            res.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.selling", (Object[])new Object[]{recipe.getOutput().toString()}));
            res.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.buying", (Object[])new Object[]{recipe.getInput().toString()}));
        }
        return res;
    }

    private static class FluidTextOverlay
    implements IDrawable {
        private final String text;

        FluidTextOverlay(FluidStack stack) {
            this.text = stack.getAmount() / 1000 + "B";
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(int x, int y) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            float f = x + this.getWidth() - fr.func_78256_a(this.text);
            int n = y + this.getHeight();
            fr.getClass();
            fr.func_175063_a(this.text, f, (float)(n - 9), -1);
        }
    }
}

