/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSemiBlock
extends Item {
    public ItemSemiBlock() {
        super(ModItems.defaultProps());
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        return this.placeSemiblock(context);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return super.func_195939_a(context);
    }

    public EntitySemiblockBase createEntity(World world, ItemStack stack, PlayerEntity player, BlockPos pos) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.getRegistryName());
        Entity e = type.func_220349_b(world, stack.func_77978_p(), null, player, pos, SpawnReason.NATURAL, false, true);
        return e instanceof EntitySemiblockBase ? (EntitySemiblockBase)e : null;
    }

    private ActionResultType placeSemiblock(ItemUseContext context) {
        World world = context.func_195991_k();
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        EntitySemiblockBase eSemi = this.createEntity(context.func_195991_k(), itemstack, context.func_195999_j(), blockpos);
        if (eSemi != null) {
            if (SemiblockTracker.getInstance().getAllSemiblocks(world, blockpos).anyMatch(s -> !s.canCoexist(eSemi))) {
                return ActionResultType.FAIL;
            }
            if (!eSemi.canPlace(direction)) {
                eSemi.func_70107_b(eSemi.func_226277_ct_() + (double)direction.func_82601_c(), eSemi.func_226278_cu_() + (double)direction.func_96559_d(), eSemi.func_226281_cx_() + (double)direction.func_82599_e());
                if (!eSemi.canPlace(direction)) {
                    return ActionResultType.FAIL;
                }
            }
            if (eSemi instanceof IDirectionalSemiblock) {
                ((IDirectionalSemiblock)((Object)eSemi)).setSide(direction);
            }
            world.func_217376_c((Entity)eSemi);
            eSemi.onPlaced(player, context.func_195996_i(), direction);
            world.func_195593_d(blockpos, world.func_180495_p(blockpos).func_177230_c());
            itemstack.func_190918_g(1);
        } else {
            Log.warning("can't get entity for semiblock item " + this.getRegistryName(), new Object[0]);
        }
        return ActionResultType.SUCCESS;
    }
}

