/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberWall;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PressureChamberRecipeImpl
extends PressureChamberRecipe {
    private final float pressureRequired;
    private final List<Ingredient> inputs;
    private final NonNullList<ItemStack> outputs;

    public PressureChamberRecipeImpl(ResourceLocation id, List<Ingredient> inputs, float pressureRequired, ItemStack ... outputs) {
        super(id);
        this.inputs = ImmutableList.copyOf(inputs);
        this.outputs = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])outputs);
        this.pressureRequired = pressureRequired;
    }

    @Override
    public float getCraftingPressure() {
        return this.pressureRequired;
    }

    @Override
    public Collection<Integer> findIngredients(IItemHandler chamberHandler) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.inputs);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            if (chamberHandler.getStackInSlot(i).func_190926_b()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(chamberHandler.getStackInSlot(i))) continue;
                iter.remove();
                slots.add(i);
                break;
            }
            if (slots.size() != this.inputs.size()) continue;
            return slots;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        return new ArrayList<Ingredient>(this.inputs);
    }

    @Override
    public NonNullList<ItemStack> getResultsForDisplay() {
        return this.outputs;
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.PRESSURE_CHAMBER;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.PRESSURE_CHAMBER.get();
    }

    public String func_193358_e() {
        return ((BlockPressureChamberWall)ModBlocks.PRESSURE_CHAMBER_WALL.get()).getRegistryName().func_110623_a();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_WALL.get());
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        ItemStack s2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_77976_d());
        return this.inputs.stream().anyMatch(ingr -> ingr.test(s2));
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots) {
        for (Ingredient ingredient : this.inputs) {
            if (ingredient.func_203189_d()) {
                return NonNullList.func_191196_a();
            }
            int nItems = ingredient.func_193365_a()[0].func_190916_E();
            for (int i = 0; i < ingredientSlots.size() && nItems > 0; ++i) {
                int slot = ingredientSlots.get(i);
                if (!ingredient.test(chamberHandler.getStackInSlot(slot))) continue;
                ItemStack extracted = chamberHandler.extractItem(slot, nItems, false);
                nItems -= extracted.func_190916_E();
            }
        }
        return this.outputs;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeFloat(this.getCraftingPressure());
        buffer.func_150787_b(this.inputs.size());
        this.inputs.forEach(i -> i.func_199564_a(buffer));
        buffer.func_150787_b(this.outputs.size());
        this.outputs.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
    }

    public static class Serializer<T extends PressureChamberRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputs = json.get("inputs").getAsJsonArray();
            ArrayList<Ingredient> inputIngredients = new ArrayList<Ingredient>();
            for (JsonElement e : inputs) {
                inputIngredients.add(Ingredient.func_199802_a((JsonElement)e.getAsJsonObject()));
            }
            float pressure = JSONUtils.func_151217_k((JsonObject)json, (String)"pressure");
            JsonArray outputs = json.get("results").getAsJsonArray();
            NonNullList results = NonNullList.func_191196_a();
            for (JsonElement e : outputs) {
                results.add((Object)ShapedRecipe.func_199798_a((JsonObject)e.getAsJsonObject()));
            }
            return this.factory.create(recipeId, inputIngredients, pressure, (ItemStack[])results.toArray((Object[])new ItemStack[0]));
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            float pressure = buffer.readFloat();
            int nInputs = buffer.func_150792_a();
            ArrayList<Ingredient> in = new ArrayList<Ingredient>();
            for (int i = 0; i < nInputs; ++i) {
                in.add(Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            int nOutputs = buffer.func_150792_a();
            ItemStack[] out = new ItemStack[nOutputs];
            for (int i = 0; i < nOutputs; ++i) {
                out[i] = buffer.func_150791_c();
            }
            return this.factory.create(recipeId, in, pressure, out);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends PressureChamberRecipe> {
            public T create(ResourceLocation var1, List<Ingredient> var2, float var3, ItemStack ... var4);
        }
    }
}

