/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HeatFrameCoolingRecipeImpl
extends HeatFrameCoolingRecipe {
    private static int maxThresholdTemp = Integer.MIN_VALUE;
    public final Ingredient input;
    private final int temperature;
    public final ItemStack output;
    private final float bonusMultiplier;
    private final float bonusLimit;

    public HeatFrameCoolingRecipeImpl(ResourceLocation id, Ingredient input, int temperature, ItemStack output) {
        this(id, input, temperature, output, 0.0f, 0.0f);
    }

    public HeatFrameCoolingRecipeImpl(ResourceLocation id, Ingredient input, int temperature, ItemStack output, float bonusMultiplier, float bonusLimit) {
        super(id);
        this.input = input;
        this.temperature = temperature;
        this.output = output;
        this.bonusMultiplier = bonusMultiplier;
        this.bonusLimit = bonusLimit;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getThresholdTemperature() {
        return this.temperature;
    }

    @Override
    public float getBonusMultiplier() {
        return this.bonusMultiplier;
    }

    @Override
    public float getBonusLimit() {
        return this.bonusLimit;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        buffer.writeInt(this.temperature);
        buffer.func_150788_a(this.output);
        buffer.writeFloat(this.bonusMultiplier);
        buffer.writeFloat(this.bonusLimit);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.HEAT_FRAME_COOLING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.HEAT_FRAME_COOLING;
    }

    public static <T extends IRecipe<?>> void cacheMaxThresholdTemp(Collection<T> recipes) {
        maxThresholdTemp = Integer.MIN_VALUE;
        for (IRecipe recipe : recipes) {
            if (!(recipe instanceof HeatFrameCoolingRecipe) || ((HeatFrameCoolingRecipe)recipe).getThresholdTemperature() <= maxThresholdTemp) continue;
            maxThresholdTemp = ((HeatFrameCoolingRecipe)recipe).getThresholdTemperature();
        }
    }

    public static int getMaxThresholdTemp(World world) {
        if (maxThresholdTemp == Integer.MIN_VALUE) {
            HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(PneumaticCraftRecipeType.HEAT_FRAME_COOLING.getRecipes(world).values());
        }
        return maxThresholdTemp;
    }

    public static class Serializer<T extends HeatFrameCoolingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int maxTemp = JSONUtils.func_151208_a((JsonObject)json, (String)"max_temp", (int)273);
            float bonusMultiplier = 0.0f;
            float bonusLimit = 0.0f;
            if (json.has("bonus_output")) {
                JsonObject bonus = json.getAsJsonObject("bonus_output");
                bonusMultiplier = JSONUtils.func_151217_k((JsonObject)bonus, (String)"multiplier");
                bonusLimit = JSONUtils.func_151217_k((JsonObject)bonus, (String)"limit");
            }
            return this.factory.create(recipeId, input, maxTemp, result, bonusMultiplier, bonusLimit);
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int temperature = buffer.readInt();
            ItemStack out = buffer.func_150791_c();
            float bonusMultiplier = buffer.readFloat();
            float bonusLimit = buffer.readFloat();
            return this.factory.create(recipeId, input, temperature, out, bonusMultiplier, bonusLimit);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends HeatFrameCoolingRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, int var3, ItemStack var4, float var5, float var6);
        }
    }
}

