/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AmadronOffer
extends AmadronRecipe {
    protected final AmadronTradeResource input;
    protected final AmadronTradeResource output;
    private final boolean isStaticOffer;
    private final int tradeLevel;

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel) {
        super(id);
        this.input = input.validate();
        this.output = output.validate();
        this.isStaticOffer = isStaticOffer;
        this.tradeLevel = tradeLevel;
    }

    @Override
    public AmadronTradeResource getInput() {
        return this.input;
    }

    @Override
    public AmadronTradeResource getOutput() {
        return this.output;
    }

    @Override
    public boolean isStaticOffer() {
        return this.isStaticOffer;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public boolean equivalentTo(AmadronPlayerOffer offer) {
        return this.input.equivalentTo(offer.getInput()) && this.output.equivalentTo(offer.getOutput());
    }

    @Override
    public String getVendor() {
        return PneumaticCraftUtils.xlate("gui.amadron", new Object[0]).func_150254_d();
    }

    public int getStock() {
        return -1;
    }

    public boolean passesQuery(String query) {
        String queryLow = query.toLowerCase();
        return this.getInput().getName().toLowerCase().contains(queryLow) || this.getOutput().getName().toLowerCase().contains(queryLow) || this.getVendor().toLowerCase().contains(queryLow);
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    @Override
    public void write(PacketBuffer buf) {
        this.input.writeToBuf(buf);
        this.output.writeToBuf(buf);
        buf.writeBoolean(this.isStaticOffer);
        buf.func_150787_b(this.tradeLevel);
    }

    public static AmadronOffer offerFromBuf(ResourceLocation id, PacketBuffer buf) {
        return new AmadronOffer(id, AmadronTradeResource.fromPacketBuf(buf), AmadronTradeResource.fromPacketBuf(buf), buf.readBoolean(), buf.func_150792_a());
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("id", this.func_199560_c().toString());
        object.add("input", (JsonElement)this.input.toJson());
        object.add("output", (JsonElement)this.output.toJson());
        object.addProperty("static", Boolean.valueOf(this.isStaticOffer));
        object.addProperty("level", (Number)this.tradeLevel);
        return object;
    }

    public static AmadronOffer fromJson(ResourceLocation id, JsonObject json) throws CommandSyntaxException {
        return new AmadronOffer(id, AmadronTradeResource.fromJson(json.getAsJsonObject("input")), AmadronTradeResource.fromJson(json.getAsJsonObject("output")), JSONUtils.func_151209_a((JsonObject)json, (String)"static", (boolean)true), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1));
    }

    public String toString() {
        return String.format("[id = %s, in = %s, out = %s]", this.func_199560_c().toString(), this.input.toString(), this.output.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronOffer)) {
            return false;
        }
        AmadronOffer that = (AmadronOffer)o;
        return this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.AMADRON_OFFERS.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.AMADRON_OFFERS;
    }

    public static class Serializer<T extends AmadronRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            try {
                return this.factory.create(recipeId, AmadronTradeResource.fromJson(json.getAsJsonObject("input")), AmadronTradeResource.fromJson(json.getAsJsonObject("output")), JSONUtils.func_151209_a((JsonObject)json, (String)"static", (boolean)true), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            return this.factory.create(recipeId, AmadronTradeResource.fromPacketBuf(buffer), AmadronTradeResource.fromPacketBuf(buffer), buffer.readBoolean(), buffer.func_150792_a());
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends AmadronRecipe> {
            public T create(ResourceLocation var1, AmadronTradeResource var2, AmadronTradeResource var3, boolean var4, int var5);
        }
    }
}

