/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.ProgWidgetRenderer;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.ItemTagMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ProgWidgetCrafting
extends ProgWidget
implements ICraftingWidget,
ICountWidget,
ISidedWidget {
    private static final boolean[] NO_SIDES = new boolean[6];
    private boolean useCount;
    private int count;

    public ProgWidgetCrafting() {
        super(ModProgWidgets.CRAFTING);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean usingVariables = false;
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                if (!itemFilter.getVariable().equals("")) {
                    usingVariables = true;
                }
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        if (!usingVariables && this.getRecipeResult(ClientUtils.getClientWorld()) == null) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.crafting.error.noCraftingRecipe", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.ITEM_FILTER, ModProgWidgets.ITEM_FILTER, ModProgWidgets.ITEM_FILTER);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CRAFTING;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public CraftingInventory getCraftingGrid() {
        CraftingInventory invCrafting = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity p_75145_1_) {
                return false;
            }
        }, 3, 3);
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                invCrafting.func_70299_a(y * 3 + x, itemFilter.getFilter());
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        return invCrafting;
    }

    public ItemStack getRecipeResult(World world) {
        CraftingInventory grid = this.getCraftingGrid();
        Optional recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)grid, world);
        return recipe.map(r -> r.func_77572_b((IInventory)grid)).orElse(ItemStack.field_190927_a);
    }

    private static IRecipe<CraftingInventory> getRecipe(World world, ICraftingWidget widget) {
        CraftingInventory grid = widget.getCraftingGrid();
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)grid, world).orElse(null);
    }

    @Override
    public void renderExtraInfo() {
        ProgWidgetRenderer.renderCraftingExtras(this);
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAICrafting(drone, (ICraftingWidget)((Object)widget));
    }

    @Override
    public void setSides(boolean[] sides) {
    }

    @Override
    public boolean[] getSides() {
        return NO_SIDES;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("useCount", this.useCount);
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.useCount);
        buf.func_150787_b(this.count);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.useCount = buf.readBoolean();
        this.count = buf.func_150792_a();
    }

    public static class DroneAICrafting
    extends Goal {
        private final ICraftingWidget widget;
        private final IDroneBase drone;

        DroneAICrafting(IDroneBase drone, ICraftingWidget widget) {
            this.drone = drone;
            this.widget = widget;
        }

        public boolean func_75250_a() {
            IRecipe recipe = ProgWidgetCrafting.getRecipe(this.drone.world(), this.widget);
            if (recipe == null) {
                return false;
            }
            CraftingInventory craftingGrid = this.widget.getCraftingGrid();
            for (int crafted = 0; !((ICountWidget)((Object)this.widget)).useCount() || crafted < ((ICountWidget)((Object)this.widget)).getCount(); ++crafted) {
                List[] equivalentsList = new List[9];
                for (int i = 0; i < equivalentsList.length; ++i) {
                    ItemStack originalStack = craftingGrid.func_70301_a(i);
                    if (originalStack.func_190926_b()) continue;
                    ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
                    for (int j = 0; j < this.drone.getInv().getSlots(); ++j) {
                        ItemStack droneStack = this.drone.getInv().getStackInSlot(j);
                        if (droneStack.func_190926_b() || droneStack.func_77973_b() != originalStack.func_77973_b() && !ItemTagMatcher.matchTags(droneStack, originalStack)) continue;
                        equivalents.add(droneStack);
                    }
                    if (equivalents.isEmpty()) {
                        return false;
                    }
                    equivalentsList[i] = equivalents;
                }
                int[] curIndexes = new int[9];
                boolean first = true;
                boolean hasCrafted = false;
                while (first || this.count(curIndexes, equivalentsList)) {
                    first = false;
                    CraftingInventory craftMatrix = new CraftingInventory(new Container(null, -1){

                        public boolean func_75145_c(PlayerEntity p_75145_1_) {
                            return false;
                        }
                    }, 3, 3);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = equivalentsList[i] == null ? ItemStack.field_190927_a : (ItemStack)equivalentsList[i].get(curIndexes[i]);
                        craftMatrix.func_70299_a(i, stack);
                    }
                    if (!recipe.func_77569_a((IInventory)craftMatrix, this.drone.world()) || !this.craft(recipe.func_77572_b((IInventory)craftMatrix), craftMatrix)) continue;
                    hasCrafted = true;
                    break;
                }
                if (hasCrafted) continue;
                return false;
            }
            return false;
        }

        private boolean count(int[] curIndexes, List<ItemStack>[] equivalentsList) {
            for (int i = 0; i < equivalentsList.length; ++i) {
                List<ItemStack> list = equivalentsList[i];
                int n = i;
                curIndexes[n] = curIndexes[n] + 1;
                if (list != null && curIndexes[i] < list.size()) {
                    return true;
                }
                curIndexes[i] = 0;
            }
            return false;
        }

        public boolean craft(ItemStack craftedStack, CraftingInventory craftMatrix) {
            int i;
            for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                int requiredCount = 0;
                ItemStack stack = craftMatrix.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                for (int j = 0; j < craftMatrix.func_70302_i_(); ++j) {
                    if (stack != craftMatrix.func_70301_a(j)) continue;
                    ++requiredCount;
                }
                if (requiredCount <= stack.func_190916_E()) continue;
                return false;
            }
            BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)this.drone.getFakePlayer(), (ItemStack)craftedStack, (IInventory)craftMatrix);
            for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack itemstack1 = craftMatrix.func_70301_a(i);
                if (itemstack1.func_190926_b()) continue;
                if (itemstack1.func_77973_b().hasContainerItem(itemstack1)) {
                    ItemStack itemstack2 = itemstack1.func_77973_b().getContainerItem(itemstack1);
                    if (!itemstack2.func_190926_b() && itemstack2.func_77984_f() && itemstack2.func_77952_i() > itemstack2.func_77958_k()) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((PlayerEntity)this.drone.getFakePlayer(), itemstack2, Hand.MAIN_HAND));
                        continue;
                    }
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.drone.getInv(), (ItemStack)itemstack2.func_77946_l(), (boolean)false);
                    if (!remainder.func_190926_b()) {
                        Vec3d pos = this.drone.getDronePos();
                        ItemEntity item = new ItemEntity(this.drone.world(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, remainder);
                        this.drone.world().func_217376_c((Entity)item);
                    }
                }
                itemstack1.func_190918_g(1);
            }
            for (i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack stack = this.drone.getInv().getStackInSlot(i);
                if (stack.func_190916_E() > 0) continue;
                this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
            }
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.drone.getInv(), (ItemStack)craftedStack, (boolean)false);
            if (!remainder.func_190926_b()) {
                Vec3d pos = this.drone.getDronePos();
                ItemEntity item = new ItemEntity(this.drone.world(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, remainder);
                this.drone.world().func_217376_c((Entity)item);
            }
            return true;
        }
    }
}

