/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketJetBootsStateSync {
    private UUID playerId;
    private JetBootsStateTracker.JetBootsState state;

    public PacketJetBootsStateSync() {
    }

    public PacketJetBootsStateSync(PlayerEntity player, JetBootsStateTracker.JetBootsState state) {
        this.playerId = player.func_110124_au();
        this.state = state;
    }

    PacketJetBootsStateSync(PacketBuffer buf) {
        this.playerId = new UUID(buf.readLong(), buf.readLong());
        this.state = new JetBootsStateTracker.JetBootsState(buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
        buf.writeBoolean(this.state.isEnabled());
        buf.writeBoolean(this.state.isActive());
        buf.writeBoolean(this.state.isBuilderMode());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> JetBootsStateTracker.getTracker(ClientUtils.getClientPlayer()).setJetBootsState(this.playerId, this.state));
        ctx.get().setPacketHandled(true);
    }
}

