/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAphorismTileUpdate
extends LocationIntPacket {
    private static final int MAX_LENGTH = 1024;
    private String[] text;
    private int textRotation;

    public PacketAphorismTileUpdate() {
    }

    public PacketAphorismTileUpdate(PacketBuffer buffer) {
        super(buffer);
        this.textRotation = buffer.readByte();
        int lines = buffer.func_150792_a();
        this.text = new String[lines];
        for (int i = 0; i < lines; ++i) {
            this.text[i] = buffer.func_150789_c(1024);
        }
    }

    public PacketAphorismTileUpdate(TileEntityAphorismTile tile) {
        super(tile.func_174877_v());
        this.text = tile.getTextLines();
        this.textRotation = tile.textRotation;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.textRotation);
        buffer.func_150787_b(this.text.length);
        Arrays.stream(this.text).forEach(s -> buffer.func_211400_a(s, 1024));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_175625_s(this.pos);
            if (te instanceof TileEntityAphorismTile) {
                ((TileEntityAphorismTile)te).setTextLines(this.text, false);
                ((TileEntityAphorismTile)te).textRotation = this.textRotation;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

