/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IMagnetSuppressor;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.Validate;

public class ItemRegistry
implements IItemRegistry {
    private static final ItemRegistry INSTANCE = new ItemRegistry();
    public final List<IInventoryItem> inventoryItems = new ArrayList<IInventoryItem>();
    private final Map<EnumUpgrade, List<IUpgradeAcceptor>> upgradeToAcceptors = new HashMap<EnumUpgrade, List<IUpgradeAcceptor>>();
    private final List<IMagnetSuppressor> magnetSuppressors = new ArrayList<IMagnetSuppressor>();

    public static ItemRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerInventoryItem(@Nonnull IInventoryItem handler) {
        Validate.notNull((Object)handler);
        this.inventoryItems.add(handler);
    }

    @Override
    public void registerUpgradeAcceptor(@Nonnull IUpgradeAcceptor upgradeAcceptor) {
        Map<EnumUpgrade, Integer> applicableUpgrades = upgradeAcceptor.getApplicableUpgrades();
        if (applicableUpgrades != null) {
            for (EnumUpgrade applicableUpgrade : applicableUpgrades.keySet()) {
                List acceptors = this.upgradeToAcceptors.computeIfAbsent(applicableUpgrade, k -> new ArrayList());
                acceptors.add(upgradeAcceptor);
            }
        }
    }

    @Override
    public void addTooltip(EnumUpgrade upgrade, List<ITextComponent> tooltip) {
        List<IUpgradeAcceptor> acceptors = this.upgradeToAcceptors.get((Object)upgrade);
        if (acceptors != null) {
            ArrayList<String> tempList = new ArrayList<String>(acceptors.size());
            for (IUpgradeAcceptor acceptor : acceptors) {
                tempList.add("\u2022 " + I18n.func_135052_a((String)acceptor.getUpgradeAcceptorTranslationKey(), (Object[])new Object[0]));
            }
            Collections.sort(tempList);
            tooltip.addAll(tempList.stream().map(StringTextComponent::new).collect(Collectors.toList()));
        }
    }

    @Override
    public void registerMagnetSuppressor(IMagnetSuppressor suppressor) {
        this.magnetSuppressors.add(suppressor);
    }

    public boolean shouldSuppressMagnet(Entity e) {
        return this.magnetSuppressors.stream().anyMatch(s -> s.shouldSuppressMagnet(e));
    }
}

