/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.inventory.IPhantomSlot;
import me.desht.pneumaticcraft.common.inventory.SlotUpgrade;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerPneumaticBase<T extends TileEntityBase>
extends Container
implements IGUIButtonSensitive {
    private static final String[] ARMOR_SLOT_TEXTURES = new String[]{"item/empty_armor_slot_boots", "item/empty_armor_slot_leggings", "item/empty_armor_slot_chestplate", "item/empty_armor_slot_helmet"};
    public final T te;
    private final List<SyncedField> syncedFields = new ArrayList<SyncedField>();
    private boolean firstTick = true;
    int playerSlotsStart;
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};

    public ContainerPneumaticBase(ContainerType type, int windowId, PlayerInventory invPlayer, PacketBuffer extraData) {
        this(type, windowId, invPlayer, ContainerPneumaticBase.getTilePos(extraData));
    }

    public ContainerPneumaticBase(ContainerType type, int windowId, PlayerInventory invPlayer) {
        this(type, windowId, invPlayer, (BlockPos)null);
    }

    public ContainerPneumaticBase(ContainerType type, int windowId, PlayerInventory invPlayer, BlockPos tilePos) {
        super(type, windowId);
        if (tilePos != null) {
            TileEntity te0 = invPlayer.field_70458_d.field_70170_p.func_175625_s(tilePos);
            if (te0 instanceof TileEntityBase) {
                this.te = (TileEntityBase)te0;
                this.addSyncedFields(this.te);
            } else {
                this.te = null;
            }
        } else {
            this.te = null;
        }
    }

    static BlockPos getTilePos(PacketBuffer extraData) {
        return extraData.func_179259_c();
    }

    void addSyncedField(SyncedField field) {
        this.syncedFields.add(field);
        field.setLazy(false);
    }

    void addSyncedFields(Object annotatedObject) {
        List<SyncedField> fields = NetworkUtils.getSyncedFields(annotatedObject, GuiSynced.class);
        for (SyncedField field : fields) {
            this.addSyncedField(field);
        }
    }

    public void updateField(int index, Object value) {
        this.syncedFields.get(index).setValue(value);
        if (this.te != null) {
            ((TileEntityBase)this.te).onGuiUpdate();
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return ((TileEntityBase)this.te).isGuiUseableByPlayer(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.syncedFields.size(); ++i) {
            if (!this.syncedFields.get(i).update() && !this.firstTick) continue;
            this.sendToContainerListeners(new PacketUpdateGui(i, this.syncedFields.get(i)));
        }
        this.firstTick = false;
    }

    void sendToContainerListeners(Object message) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            NetworkHandler.sendToPlayer(message, (ServerPlayerEntity)listener);
        }
    }

    protected void addPlayerSlots(PlayerInventory inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(PlayerInventory inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.field_75151_b.size();
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, xOffset + inventoryColumnIndex * 18, yOffset + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, xOffset + actionBarSlotIndex * 18, yOffset + 58));
        }
    }

    protected void addUpgradeSlots(int xBase, int yBase) {
        for (int i = 0; i < ((TileEntityBase)this.te).getUpgradeHandler().getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotUpgrade((TileEntityBase)this.te, i, xBase + i % 2 * 18, yBase + i / 2 * 18));
        }
    }

    void addArmorSlots(final PlayerInventory inventoryPlayer, int xBase, int yBase) {
        for (int i = 0; i < 4; ++i) {
            final EquipmentSlotType entityequipmentslot = VALID_EQUIPMENT_SLOTS[i];
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, 36 + (3 - i), xBase, yBase + i * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(entityequipmentslot, (Entity)inventoryPlayer.field_70458_d);
                }

                public boolean func_82869_a(PlayerEntity playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public String getSlotTexture() {
                    return ARMOR_SLOT_TEXTURES[entityequipmentslot.func_188454_b()];
                }
            });
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slot) {
        Slot srcSlot = (Slot)this.field_75151_b.get(slot);
        if (srcSlot == null || !srcSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack srcStack = srcSlot.func_75211_c().func_77946_l();
        ItemStack copyOfSrcStack = srcStack.func_77946_l();
        if (slot < this.playerSlotsStart ? !this.func_75135_a(srcStack, this.playerSlotsStart, this.playerSlotsStart + 36, false) : !this.func_75135_a(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.field_190927_a;
        }
        srcSlot.func_75215_d(srcStack);
        srcSlot.func_75220_a(srcStack, copyOfSrcStack);
        srcSlot.func_190901_a(player, srcStack);
        return copyOfSrcStack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && ContainerPneumaticBase.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_178170_b(itemstack), Math.min(slot.func_75219_a(), stack.func_77976_d())))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    int limit = Math.min(slot1.func_75219_a(), slot1.func_178170_b(stack));
                    if (stack.func_190916_E() > limit) {
                        slot1.func_75215_d(stack.func_77979_a(limit));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof IPhantomSlot) {
            return this.slotClickPhantom(slot, dragType, clickType, player);
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    @Nonnull
    private ItemStack slotClickPhantom(Slot slot, int dragType, ClickType clickType, PlayerEntity player) {
        ItemStack stack = ItemStack.field_190927_a;
        if (clickType == ClickType.CLONE && dragType == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            PlayerInventory playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            stack = stackSlot.func_77946_l();
            if (stackSlot.func_190926_b()) {
                if (!stackHeld.func_190926_b() && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            } else if (stackHeld.func_190926_b()) {
                this.adjustPhantomSlot(slot, clickType, dragType);
                slot.func_190901_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (this.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, clickType, dragType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            }
        }
        return stack;
    }

    private boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private void adjustPhantomSlot(Slot slot, ClickType clickType, int dragType) {
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c().func_77946_l();
        if (dragType == 1) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.func_190920_e(Math.min(stackSlot.func_190916_E() * 2, slot.func_75219_a()));
            } else {
                stackSlot.func_190920_e(Math.min(stackSlot.func_190916_E() + 1, slot.func_75219_a()));
            }
        } else if (dragType == 0) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.func_190920_e(stackSlot.func_190916_E() / 2);
            } else {
                stackSlot.func_190918_g(1);
            }
        }
        slot.func_75215_d(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int dragType) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = dragType == 0 ? stackHeld.func_190916_E() : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.func_190920_e(stackSize);
        slot.func_75215_d(phantomStack);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (this.te != null) {
            ((TileEntityBase)this.te).handleGUIButtonPress(tag, shiftHeld, player);
        }
    }
}

