/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class HeatExchangerLogicAmbient
extends HeatExchangerLogicConstant {
    static final double BASE_AMBIENT_TEMP = 300.0;
    private static final HeatExchangerLogicAmbient DEFAULT_AIR_EXCHANGER = new HeatExchangerLogicAmbient(300.0);
    private static final Int2ObjectOpenHashMap<HeatExchangerLogicAmbient> exchangers = new Int2ObjectOpenHashMap();

    public static HeatExchangerLogicAmbient atPosition(IWorld world, BlockPos pos) {
        if (PNCConfig.Common.Heat.ambientTempBiomeModifier == 0.0 && PNCConfig.Common.Heat.ambientTempHeightModifier == 0.0) {
            return DEFAULT_AIR_EXCHANGER;
        }
        float t = world.func_226691_t_(pos).func_185353_n() - 0.8f;
        int h = 0;
        if (pos.func_177956_o() > 80) {
            h = 80 - pos.func_177956_o();
        } else if (pos.func_177956_o() < 40) {
            h = 40 - pos.func_177956_o();
        }
        int temp = (int)(300.0 + PNCConfig.Common.Heat.ambientTempBiomeModifier * (double)t + PNCConfig.Common.Heat.ambientTempHeightModifier * (double)h);
        return (HeatExchangerLogicAmbient)exchangers.computeIfAbsent(temp, HeatExchangerLogicAmbient::new);
    }

    private HeatExchangerLogicAmbient(double temperature) {
        super(temperature, PNCConfig.Common.Heat.airThermalResistance);
    }
}

