/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntitySemiblockBase
extends Entity
implements ISemiBlock,
IGUIButtonSensitive {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntitySemiblockBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntitySemiblockBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final float MAX_HEALTH = 40.0f;
    private TileEntity cachedTE;
    private boolean shouldDropItem = true;
    private AxisAlignedBB blockBounds;
    private BlockPos blockPos;
    private Vec3d dropOffset = Vec3d.field_186680_a;

    EntitySemiblockBase(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void onBroken() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.shouldDropItem) {
                this.getDrops().forEach(this::dropItem);
            }
            this.field_70170_p.func_195593_d(this.blockPos, this.field_70170_p.func_180495_p(this.blockPos).func_177230_c());
        }
    }

    private void dropItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.dropOffset.func_82615_a(), this.func_226278_cu_() + this.dropOffset.func_82617_b(), this.func_226281_cx_() + this.dropOffset.func_82616_c(), stack);
            itemEntity.func_174869_p();
            if (this.captureDrops() != null) {
                this.captureDrops().add(itemEntity);
            } else {
                this.field_70170_p.func_217376_c((Entity)itemEntity);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            this.func_174826_a(this.getBlockBounds().func_186670_a(this.blockPos));
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (this.func_70089_S() && !this.canStay()) {
            this.func_70106_y();
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d hitVec, Hand hand) {
        Vec3d end;
        Vec3d eye = player.func_174824_e(0.0f);
        RayTraceContext ctx = new RayTraceContext(eye, end = eye.func_178787_e(player.func_70040_Z().func_72432_b().func_186678_a(5.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
        BlockRayTraceResult brtr = player.field_70170_p.func_217299_a(ctx);
        if (brtr == null) {
            return ActionResultType.PASS;
        }
        if (player.func_184586_b(hand).func_77973_b() == ModItems.LOGISTICS_CONFIGURATOR.get()) {
            if (player.func_226271_bk_()) {
                this.removeSemiblock(player);
                return ActionResultType.SUCCESS;
            }
            if (this.onRightClickWithConfigurator(player, brtr.func_216354_b())) {
                player.func_184586_b(hand).getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> h.addAir(-50));
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (player.func_226271_bk_()) {
            ItemUseContext itemCtx = new ItemUseContext(player, hand, brtr);
            ActionResultType res = player.func_184586_b(hand).onItemUseFirst(itemCtx);
            return res == ActionResultType.PASS ? player.func_184586_b(hand).func_196084_a(itemCtx) : res;
        }
        return this.getBlockState().func_227031_a_(this.field_70170_p, player, hand, brtr);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void func_70107_b(double x, double y, double z) {
        if (!this.isAddedToWorld()) {
            super.func_70107_b(x, y, z);
            this.blockPos = new BlockPos(x, y, z);
        }
    }

    public float func_70013_c() {
        return ClientUtils.getBrightnessAtWorldHeight();
    }

    public BlockState getBlockState() {
        return this.field_70170_p.func_180495_p(this.blockPos);
    }

    @Override
    public TileEntity getCachedTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            this.cachedTE = this.field_70170_p.func_175625_s(this.blockPos);
        }
        return this.cachedTE;
    }

    protected Item getDroppedItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.getId());
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.func_191196_a();
        Item item = this.getDroppedItem();
        if (item != null) {
            ItemStack stack = new ItemStack((IItemProvider)this.getDroppedItem());
            CompoundNBT tag = new CompoundNBT();
            this.serializeNBT(tag);
            if (!tag.isEmpty()) {
                stack.func_196082_o().func_218657_a("EntityTag", (INBT)tag);
            }
            drops.add((Object)stack);
        }
        return drops;
    }

    public AxisAlignedBB getBlockBounds() {
        if (this.blockBounds == null) {
            this.blockBounds = this.field_70170_p == null || this.field_70170_p.func_180495_p(this.blockPos).isAir((IBlockReader)this.field_70170_p, this.blockPos) ? VoxelShapes.func_197868_b().func_197752_a() : this.field_70170_p.func_180495_p(this.blockPos).func_196954_c((IBlockReader)this.field_70170_p, this.blockPos).func_197752_a();
        }
        return this.blockBounds;
    }

    public boolean canStay() {
        return this.canPlace(null);
    }

    @Override
    public ResourceLocation getId() {
        return this.func_200600_R().getRegistryName();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT tag) {
        return tag;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
        this.serializeNBT(compound);
    }

    @Override
    public boolean isValid() {
        return this.func_70089_S();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            Direction dir;
            Direction direction = dir = this instanceof IDirectionalSemiblock ? ((IDirectionalSemiblock)((Object)this)).getSide() : null;
            if (SemiblockTracker.getInstance().putSemiblock(this.field_70170_p, this.blockPos, this)) {
                MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.PlaceEvent(this.field_70170_p.func_201672_e(), this.blockPos, this));
            } else {
                Log.error("found existing semiblock at %s, pos=%s, dir=%s", this.field_70170_p, this.blockPos, dir);
            }
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K) {
            Direction dir = this instanceof IDirectionalSemiblock ? ((IDirectionalSemiblock)((Object)this)).getSide() : null;
            SemiblockTracker.getInstance().clearSemiblock(this.field_70170_p, this.blockPos, dir);
            MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.BreakEvent(this.field_70170_p.func_201672_e(), this.blockPos, this));
        }
        this.onBroken();
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public int getTrackingId() {
        return this.isAddedToWorld() ? this.func_145782_y() : -1;
    }

    @Override
    public boolean canCoexist(ISemiBlock otherSemiblock) {
        if (this instanceof IDirectionalSemiblock) {
            return !(otherSemiblock instanceof IDirectionalSemiblock) || ((IDirectionalSemiblock)((Object)this)).getSide() != ((IDirectionalSemiblock)((Object)otherSemiblock)).getSide();
        }
        return otherSemiblock instanceof IDirectionalSemiblock;
    }

    @Override
    public void removeSemiblock(PlayerEntity player) {
        player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
        this.dropOffset = player.func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b();
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean isCreative;
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = isCreative = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (isCreative || this.getDamageTaken() > 40.0f) {
                this.shouldDropItem = !isCreative;
                this.func_70106_y();
            }
        }
        return true;
    }

    private void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    private void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public boolean isAir() {
        return this.getBlockState().isAir((IBlockReader)this.field_70170_p, this.blockPos);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
    }

    @Override
    public void writeToBuf(PacketBuffer payload) {
    }

    @Override
    public void readFromBuf(PacketBuffer payload) {
    }
}

