/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIBlockInteract
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();

    public DroneAIBlockInteract(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        drone.getFakePlayer().func_226284_e_(((IBlockRightClicker)((Object)widget)).isSneaking());
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return !this.visitedPositions.contains(pos) && (this.progWidget.isItemFilterEmpty() || DroneAIDig.isBlockValidForFilter((IBlockReader)this.drone.world(), pos, this.drone, this.progWidget));
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        this.visitedPositions.add(pos);
        boolean result = this.rightClick(pos);
        if (this.drone.getFakePlayer().func_184614_ca().func_190916_E() <= 0) {
            this.drone.getFakePlayer().func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        return result;
    }

    private boolean rightClick(BlockPos pos) {
        Direction faceDir = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
        FakePlayer fakePlayer = this.drone.getFakePlayer();
        World world = this.drone.world();
        ItemStack stack = fakePlayer.func_184614_ca();
        BlockPos pos2 = pos.func_177972_a(faceDir.func_176734_d());
        fakePlayer.func_70107_b((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
        fakePlayer.field_70125_A = faceDir.func_176734_d().func_96559_d() * -90;
        fakePlayer.field_70177_z = PneumaticCraftUtils.getYawFromFacing(faceDir.func_176734_d());
        try {
            Block block;
            Vec3d blockVec = PneumaticCraftUtils.getBlockCentre(pos);
            BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(fakePlayer.func_213303_ch(), blockVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)fakePlayer));
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (Direction)faceDir);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return false;
            }
            ActionResultType ret = stack.onItemUseFirst(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
            if (ret != ActionResultType.PASS) {
                return false;
            }
            boolean bypass = fakePlayer.func_184614_ca().doesSneakBypassUse((IWorldReader)world, pos, (PlayerEntity)fakePlayer);
            ActionResultType result = ActionResultType.PASS;
            if ((!fakePlayer.func_226271_bk_() || bypass || event.getUseBlock() == Event.Result.ALLOW) && event.getUseBlock() != Event.Result.DENY && world.func_180495_p(pos).func_227031_a_(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr) == ActionResultType.SUCCESS) {
                result = ActionResultType.SUCCESS;
            }
            if (stack.func_190926_b() || fakePlayer.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return false;
            }
            if (stack.func_77973_b() instanceof BlockItem && !fakePlayer.func_195070_dx() && ((block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof CommandBlockBlock || block instanceof StructureBlock)) {
                return false;
            }
            if (result != ActionResultType.SUCCESS && event.getUseItem() != Event.Result.DENY || result == ActionResultType.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                ItemStack copyBeforeUse = stack.func_77946_l();
                result = stack.func_196084_a(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
                if (result == ActionResultType.PASS) {
                    ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND);
                    fakePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
                }
                if (fakePlayer.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)fakePlayer, (ItemStack)copyBeforeUse, (Hand)Hand.MAIN_HAND);
                }
            }
            return false;
        }
        catch (Throwable e) {
            Log.error("DroneAIBlockInteract crashed! Stacktrace: ", new Object[0]);
            e.printStackTrace();
            return false;
        }
    }
}

