/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.sound.MovingSoundAirLeak;
import me.desht.pneumaticcraft.client.sound.MovingSoundElevator;
import me.desht.pneumaticcraft.client.sound.MovingSoundJetBoots;
import me.desht.pneumaticcraft.client.sound.MovingSoundMinigun;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class MovingSounds {
    private static final Map<BlockPos, TickableSound> posToTickableSound = new HashMap<BlockPos, TickableSound>();

    private static TickableSound createMovingSound(Sound s, Object focus, Object ... extraData) {
        switch (s) {
            case JET_BOOTS: {
                if (!(focus instanceof PlayerEntity)) break;
                return new MovingSoundJetBoots((PlayerEntity)focus);
            }
            case MINIGUN: {
                if (focus instanceof PlayerEntity || focus instanceof EntityDrone) {
                    return new MovingSoundMinigun((Entity)focus);
                }
                if (!(focus instanceof BlockPos)) break;
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s((BlockPos)focus);
                return te == null ? null : new MovingSoundMinigun(te);
            }
            case ELEVATOR: {
                TileEntity te;
                if (!(focus instanceof BlockPos) || !((te = Minecraft.func_71410_x().field_71441_e.func_175625_s((BlockPos)focus)) instanceof TileEntityElevatorBase)) break;
                return new MovingSoundElevator((TileEntityElevatorBase)te);
            }
            case AIR_LEAK: {
                if (!(focus instanceof BlockPos)) break;
                TickableSound sound = posToTickableSound.get(focus);
                if (sound != null && !sound.func_147667_k()) {
                    return null;
                }
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s((BlockPos)focus);
                if (!te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) break;
                sound = new MovingSoundAirLeak(te, (Direction)extraData[0]);
                posToTickableSound.put((BlockPos)focus, sound);
                return sound;
            }
        }
        throw new IllegalArgumentException("Invalid moving sound " + (Object)((Object)s) + " for focus object " + focus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playMovingSound(Sound s, Object focus, Object ... extraData) {
        TickableSound movingSound = MovingSounds.createMovingSound(s, focus, extraData);
        if (movingSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)movingSound);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Listener {
        private Listener() {
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
            if (event.getWorld().field_72995_K && event.getEntity() instanceof ClientPlayerEntity) {
                posToTickableSound.clear();
            }
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            posToTickableSound.values().removeIf(TickableSound::func_147667_k);
        }
    }

    public static enum Sound {
        JET_BOOTS,
        MINIGUN,
        ELEVATOR,
        AIR_LEAK;

    }
}

