/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RenderNavigator {
    private final BlockPos targetPos;
    private Path path;
    private boolean increaseAlpha;
    private float alphaValue = 0.2f;

    public RenderNavigator(World world, BlockPos targetPos) {
        this.targetPos = targetPos;
        this.updatePath();
    }

    public void updatePath() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        MobEntity e = PneumaticCraftUtils.createDummyEntity((PlayerEntity)player);
        this.path = e.func_70661_as().func_179680_a(this.targetPos, 0);
        if (!this.tracedToDestination()) {
            this.path = CoordTrackUpgradeHandler.getDronePath((PlayerEntity)player, this.targetPos);
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, boolean wirePath, boolean xRayEnabled, float partialTicks) {
        if (this.path == null) {
            return;
        }
        boolean hasDestinationPath = this.tracedToDestination();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.01, 0.0);
        if (wirePath) {
            IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getNavPath(xRayEnabled, false));
            for (int i = 1; i < this.path.func_75874_d(); ++i) {
                float red = 1.0f;
                if (this.path.func_75874_d() - i < 200) {
                    red = (float)(this.path.func_75874_d() - i) * 0.005f;
                }
                PathPoint lastPoint = this.path.func_75877_a(i - 1);
                PathPoint pathPoint = this.path.func_75877_a(i);
                builder.func_225582_a_((double)lastPoint.field_75839_a + 0.5, (double)lastPoint.field_75837_b, (double)lastPoint.field_75838_c + 0.5).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
                builder.func_225582_a_((double)(lastPoint.field_75839_a + pathPoint.field_75839_a) / 2.0 + 0.5, (double)Math.max(lastPoint.field_75837_b, pathPoint.field_75837_b), (double)(lastPoint.field_75838_c + pathPoint.field_75838_c) / 2.0 + 0.5).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
                builder.func_225582_a_((double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b, (double)pathPoint.field_75838_c + 0.5).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
            }
        } else {
            IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getNavPath(xRayEnabled, true));
            if (hasDestinationPath) {
                if (this.alphaValue > 0.2f) {
                    this.alphaValue -= 0.005f;
                }
            } else if (this.increaseAlpha) {
                this.alphaValue += 0.005f;
                if (this.alphaValue > 0.3f) {
                    this.increaseAlpha = false;
                }
            } else {
                this.alphaValue -= 0.005f;
                if (this.alphaValue < 0.2f) {
                    this.increaseAlpha = true;
                }
            }
            for (int i = 0; i < this.path.func_75874_d(); ++i) {
                float red = 1.0f;
                if (this.path.func_75874_d() - i < 200) {
                    red = (float)(this.path.func_75874_d() - i) * 0.005f;
                }
                PathPoint pathPoint = this.path.func_75877_a(i);
                builder.func_225582_a_((double)pathPoint.field_75839_a, (double)pathPoint.field_75837_b, (double)pathPoint.field_75838_c).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_225582_a_((double)pathPoint.field_75839_a, (double)pathPoint.field_75837_b, (double)(pathPoint.field_75838_c + 1)).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_225582_a_((double)(pathPoint.field_75839_a + 1), (double)pathPoint.field_75837_b, (double)(pathPoint.field_75838_c + 1)).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_225582_a_((double)(pathPoint.field_75839_a + 1), (double)pathPoint.field_75837_b, (double)pathPoint.field_75838_c).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
            }
        }
        matrixStack.func_227865_b_();
    }

    public boolean tracedToDestination() {
        if (this.path == null) {
            return false;
        }
        PathPoint finalPoint = this.path.func_75870_c();
        return finalPoint != null && this.targetPos.equals((Object)new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c));
    }
}

