/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiHelmetMainScreen
extends GuiPneumaticScreenBase
implements IGuiScreen {
    private static final String TITLE_PREFIX = TextFormatting.AQUA + "" + TextFormatting.UNDERLINE;
    public static final ItemStack[] ARMOR_STACKS = new ItemStack[]{new ItemStack((IItemProvider)ModItems.PNEUMATIC_BOOTS.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_LEGGINGS.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_CHESTPLATE.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_HELMET.get())};
    private final List<UpgradeOption> upgradeOptions = new ArrayList<UpgradeOption>();
    private static int pageNumber;
    private boolean inInitPhase = true;
    private static GuiHelmetMainScreen instance;

    private GuiHelmetMainScreen() {
        super((ITextComponent)new StringTextComponent("Main Screen"));
    }

    public static GuiHelmetMainScreen getInstance() {
        return instance;
    }

    public static void initHelmetMainScreen() {
        if (instance == null) {
            instance = new GuiHelmetMainScreen();
            MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
            int width = mw.func_198107_o();
            int height = mw.func_198087_p();
            instance.init(Minecraft.func_71410_x(), width, height);
            int i = 1;
            while (i < GuiHelmetMainScreen.instance.upgradeOptions.size()) {
                pageNumber = i++;
                instance.init();
            }
            pageNumber = 0;
            GuiHelmetMainScreen.instance.inInitPhase = false;
        }
    }

    @Override
    public void init() {
        super.init();
        this.buttons.clear();
        this.children.clear();
        this.upgradeOptions.clear();
        this.addPages();
        for (int i = 0; i < this.upgradeOptions.size(); ++i) {
            int idx = i;
            WidgetButtonExtended button = new WidgetButtonExtended(210, 20 + i * 22, 120, 20, this.upgradeOptions.get(i).page.getPageName(), b -> this.setPage(idx));
            button.setRenderStacks(this.upgradeOptions.get(i).icons);
            button.setIconPosition(WidgetButtonExtended.IconPosition.RIGHT);
            if (pageNumber == i) {
                button.active = false;
            }
            this.addButton((Widget)button);
        }
        if (pageNumber > this.upgradeOptions.size() - 1) {
            pageNumber = this.upgradeOptions.size() - 1;
        }
        String keybindName = this.upgradeOptions.get(pageNumber).upgradeName;
        WidgetKeybindCheckBox checkBox = new WidgetKeybindCheckBox(40, 25, -1, keybindName, null);
        if (this.upgradeOptions.get(pageNumber).page.isToggleable()) {
            this.addButton(checkBox);
        }
        this.upgradeOptions.get(pageNumber).page.populateGui(this);
    }

    private void setPage(int newPage) {
        pageNumber = newPage;
        this.init();
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    private void addPages() {
        for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IOptionPage optionPage;
                if (!this.inInitPhase && !CommonArmorHandler.getHandlerForPlayer().isUpgradeRendererInserted(slot, i)) continue;
                IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!this.inInitPhase && !ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)Minecraft.func_71410_x().field_71439_g, slot) && !(upgradeRenderHandler instanceof MainHelmetHandler) || (optionPage = upgradeRenderHandler.getGuiOptionsPage(this)) == null) continue;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(ARMOR_STACKS[upgradeRenderHandler.getEquipmentSlot().func_188454_b()]);
                Arrays.stream(upgradeRenderHandler.getRequiredUpgrades()).map(EnumUpgrade::getItemStack).forEach(stacks::add);
                this.upgradeOptions.add(new UpgradeOption(optionPage, upgradeRenderHandler.getUpgradeID(), stacks.toArray(new ItemStack[0])));
            }
        }
    }

    @Override
    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        IOptionPage optionPage = this.upgradeOptions.get(pageNumber).page;
        optionPage.renderPre(x, y, partialTicks);
        this.drawCenteredString(this.font, TITLE_PREFIX + this.upgradeOptions.get(pageNumber).page.getPageName(), 100, 12, -1);
        if (optionPage.displaySettingsHeader()) {
            this.drawCenteredString(this.font, "Settings", 100, optionPage.settingsYposition(), -1);
        }
        super.render(x, y, partialTicks);
        optionPage.renderPost(x, y, partialTicks);
    }

    @Override
    public void tick() {
        super.tick();
        IOptionPage optionPage = this.upgradeOptions.get(pageNumber).page;
        optionPage.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.upgradeOptions.get(pageNumber).page.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.upgradeOptions.get(pageNumber).page.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dir) {
        return this.upgradeOptions.get(pageNumber).page.mouseScrolled(mouseX, mouseY, dir) || super.mouseScrolled(mouseX, mouseY, dir);
    }

    @Override
    public <T extends Widget> T addWidget(T w) {
        return (T)this.addButton(w);
    }

    @Override
    public List<Widget> getWidgetList() {
        return this.buttons;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.font;
    }

    @Override
    public void setFocusedWidget(Widget w) {
        this.setFocused((IGuiEventListener)w);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class UpgradeOption {
        private final IOptionPage page;
        private final String upgradeName;
        private final ItemStack[] icons;

        UpgradeOption(IOptionPage page, String upgradeName, ItemStack ... icons) {
            this.page = page;
            this.upgradeName = upgradeName;
            this.icons = icons;
        }
    }
}

