/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidHopper;
import me.desht.pneumaticcraft.common.tileentity.TileEntityLiquidHopper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.IFluidTank;

public class GuiLiquidHopper
extends GuiPneumaticContainerBase<ContainerLiquidHopper, TileEntityLiquidHopper> {
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];

    public GuiLiquidHopper(ContainerLiquidHopper container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new WidgetTank(this.field_147003_i + 116, this.field_147009_r + 15, (IFluidTank)((TileEntityLiquidHopper)this.te).getTank()));
        this.statusStat = this.addAnimatedStat("gui.tab.hopperStatus", new ItemStack((IItemProvider)ModBlocks.LIQUID_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat("gui.tab.gasLift.mode", new ItemStack((IItemProvider)Blocks.field_150442_at), -13312, false);
        optionStat.addPadding(4, 14);
        WidgetButtonExtended button = new WidgetButtonExtended(5, 20, 20, 20, "").withTag("empty");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151133_ar));
        button.setTooltipText(I18n.func_135052_a((String)"gui.tab.liquidHopper.mode.empty", (Object[])new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(30, 20, 20, 20, "").withTag("leave");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151131_as));
        button.setTooltipText(I18n.func_135052_a((String)"gui.tab.liquidHopper.mode.leaveLiquid", (Object[])new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[1] = button;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    public void tick() {
        super.tick();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].active = ((TileEntityLiquidHopper)this.te).doesLeaveMaterial();
        this.modeButtons[1].active = !((TileEntityLiquidHopper)this.te).doesLeaveMaterial();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_HOPPER;
    }

    private List<String> getStatus() {
        ArrayList<String> textList = new ArrayList<String>();
        int itemsPer = ((TileEntityLiquidHopper)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.add(I18n.func_135052_a((String)"gui.tab.hopperStatus.liquidTransferPerTick", (Object[])new Object[]{itemsPer * 100}));
        } else {
            int transferInterval = ((TileEntityLiquidHopper)this.te).getItemTransferInterval();
            textList.add(I18n.func_135052_a((String)"gui.tab.hopperStatus.liquidTransferPerSecond", (Object[])new Object[]{transferInterval == 0 ? "2000" : PneumaticCraftUtils.roundNumberTo(2000.0f / (float)transferInterval, 1)}));
        }
        return textList;
    }

    @Override
    protected void addExtraUpgradeText(List<String> text) {
        if (PNCConfig.Common.Machines.liquidHopperDispenser) {
            text.add("gui.tab.upgrades.tile.liquid_hopper.dispenser");
        }
    }
}

