/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerEtchingTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityEtchingTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiEtchingTank
extends GuiPneumaticContainerBase<ContainerEtchingTank, TileEntityEtchingTank> {
    public GuiEtchingTank(ContainerEtchingTank container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 206;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new WidgetTank(this.field_147003_i + 149, this.field_147009_r + 18, ((TileEntityEtchingTank)this.te).getAcidTank()));
        this.addButton(new WidgetTemperature(this.field_147003_i + 134, this.field_147009_r + 18, 273, 773, ((TileEntityEtchingTank)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY), new int[]{323, 713}){

            @Override
            public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
                super.addTooltip(mouseX, mouseY, curTip, shift);
                int interval = ((TileEntityEtchingTank)GuiEtchingTank.this.te).getTickInterval();
                int processTimeSecs = interval * 5;
                curTip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.tooltip.etching_tank.process_time", (Object[])new Object[]{processTimeSecs}));
                if (((IHeatExchangerLogic)this.logic.orElseThrow(RuntimeException::new)).getTemperatureAsInt() > 323) {
                    float usage = (float)(30 - interval) / (5.0f * (float)interval);
                    curTip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.tooltip.etching_tank.acid_usage", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(usage, 2)}));
                }
            }
        });
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ETCHING_TANK;
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityEtchingTank)this.te).isOutputFull()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.etching_tank.output_full", (Object[])new Object[0]));
        }
        if (((TileEntityEtchingTank)this.te).isFailedOutputFull()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.etching_tank.failed_full", (Object[])new Object[0]));
        }
        if (((TileEntityEtchingTank)this.te).getAcidTank().getFluid().isEmpty()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.etching_tank.no_acid", (Object[])new Object[0]));
        }
    }
}

