/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.item;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public enum EnumUpgrade {
    VOLUME("volume"),
    DISPENSER("dispenser"),
    ITEM_LIFE("itemLife"),
    ENTITY_TRACKER("entityTracker"),
    BLOCK_TRACKER("blockTracker"),
    SPEED("speed"),
    SEARCH("search"),
    COORDINATE_TRACKER("coordinateTracker"),
    RANGE("range"),
    SECURITY("security"),
    MAGNET("magnet"),
    THAUMCRAFT("thaumcraft", 1, "thaumcraft"),
    CHARGING("charging"),
    ARMOR("armor"),
    JET_BOOTS("jetboots", 5),
    NIGHT_VISION("night_vision"),
    SCUBA("scuba"),
    CREATIVE("creative"),
    AIR_CONDITIONING("air_conditioning", 1, "toughasnails"),
    INVENTORY("inventory"),
    JUMPING("jumping", 4),
    FLIPPERS("flippers"),
    STANDBY("standby"),
    MINIGUN("minigun");

    private final String name;
    private final int maxTier;
    private final String depModId;

    private EnumUpgrade(String name) {
        this(name, 1, null);
    }

    private EnumUpgrade(String name, int maxTier) {
        this(name, maxTier, null);
    }

    private EnumUpgrade(String name, int maxTier, String depModId) {
        this.name = name;
        this.maxTier = maxTier;
        this.depModId = depModId;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    public boolean isDepLoaded() {
        return this.depModId == null || ModList.get().isLoaded(this.depModId);
    }

    public Item getItem(int tier) {
        return tier > this.maxTier ? Items.field_190931_a : (Item)ForgeRegistries.ITEMS.getValue(PneumaticRegistry.getInstance().RL(this.getItemName(tier)));
    }

    public Item getItem() {
        return this.getItem(1);
    }

    public ItemStack getItemStack() {
        Item item = this.getItem();
        return item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)this.getItem());
    }

    public String getItemName(int tier) {
        String name = this.toString().toLowerCase() + "_upgrade";
        return this.maxTier > 1 ? name + "_" + tier : name;
    }

    public static EnumUpgrade from(ItemStack stack) {
        return stack.func_77973_b() instanceof IUpgradeItem ? ((IUpgradeItem)stack.func_77973_b()).getUpgradeType() : null;
    }
}

