/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class HeatBehaviour<T extends TileEntity>
implements INBTSerializable<CompoundNBT> {
    private IHeatExchangerLogic connectedHeatLogic;
    private World world;
    private BlockPos pos;
    private T cachedTE;
    private BlockState blockState;
    private Direction direction;

    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, Direction direction) {
        this.connectedHeatLogic = connectedHeatLogic;
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.cachedTE = null;
        this.blockState = null;
        return this;
    }

    public IHeatExchangerLogic getHeatExchanger() {
        return this.connectedHeatLogic;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public T getTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            this.cachedTE = this.world.func_175625_s(this.pos);
        }
        return this.cachedTE;
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.func_180495_p(this.pos);
        }
        return this.blockState;
    }

    public abstract ResourceLocation getId();

    public abstract boolean isApplicable();

    public abstract void tick();

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("BlockPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("BlockPos"));
    }

    public boolean equals(Object o) {
        if (o instanceof HeatBehaviour) {
            HeatBehaviour behaviour = (HeatBehaviour)o;
            return behaviour.getId().equals((Object)this.getId()) && behaviour.getPos().equals((Object)this.getPos());
        }
        return false;
    }

    public int hashCode() {
        int i = this.getId().hashCode();
        i = i * 31 + this.getPos().hashCode();
        return i;
    }
}

