/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidIngredient
extends Ingredient {
    private List<Fluid> fluids;
    private final int amount;
    private ItemStack[] cachedStacks;
    private final ResourceLocation tagId;
    public static final FluidIngredient EMPTY = new FluidIngredient();

    private FluidIngredient() {
        super(Stream.empty());
        this.fluids = Collections.emptyList();
        this.amount = 0;
        this.tagId = null;
    }

    private FluidIngredient(ResourceLocation tagId, int amount) {
        super(Stream.empty());
        this.fluids = null;
        this.amount = amount;
        this.tagId = tagId;
    }

    public FluidIngredient(Collection<Fluid> fluids, int amount) {
        super(Stream.empty());
        this.fluids = ImmutableList.copyOf(fluids);
        this.amount = amount;
        this.tagId = null;
    }

    public static FluidIngredient of(int amount, Fluid ... fluids) {
        return new FluidIngredient(Arrays.asList(fluids), amount);
    }

    public static FluidIngredient of(int amount, Tag<Fluid> fluid) {
        return new FluidIngredient(fluid.func_199886_b(), amount);
    }

    private Collection<Fluid> getFluidList() {
        if (this.fluids == null && this.tagId != null) {
            Tag tag = FluidTags.func_226157_a_().func_199910_a(this.tagId);
            this.fluids = tag == null ? Collections.emptyList() : ImmutableList.copyOf((Collection)tag.func_199885_a());
        }
        return this.fluids;
    }

    public boolean func_203189_d() {
        return this.getFluidList().isEmpty();
    }

    public boolean test(@Nullable ItemStack stack) {
        return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse((Object)false);
    }

    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.getFluidList().stream().map(fluid -> FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000))).filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean testFluid(FluidStack fluidStack) {
        return this.getFluidList().stream().anyMatch(f -> fluidStack.getFluid() == f && fluidStack.getAmount() >= this.amount);
    }

    public boolean testFluid(Fluid otherFluid) {
        return this.getFluidList().stream().anyMatch(f -> f == otherFluid);
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        if (this.tagId == null) {
            json.addProperty("fluid", this.fluids.get(0).getRegistryName().toString());
        } else {
            json.addProperty("tag", this.tagId.toString());
        }
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<FluidStack> getFluidStacks() {
        return this.getFluidList().stream().map(f -> new FluidStack(f, this.amount)).collect(Collectors.toList());
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:fluid");

        public FluidIngredient parse(PacketBuffer buffer) {
            int n = buffer.func_150792_a();
            int amount = buffer.func_150792_a();
            HashSet<Fluid> fluids = new HashSet<Fluid>();
            for (int i = 0; i < n; ++i) {
                fluids.add((Fluid)buffer.readRegistryId());
            }
            return new FluidIngredient(fluids, amount);
        }

        public FluidIngredient parse(JsonObject json) {
            int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
            if (json.has("tag")) {
                ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                if (FluidTags.func_226157_a_().func_199910_a(rl) == null) {
                    throw new JsonSyntaxException("Unknown fluid tag '" + rl + "'");
                }
                return new FluidIngredient(rl, amount);
            }
            if (json.has("fluid")) {
                ResourceLocation fluidName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
                }
                return new FluidIngredient(Collections.singletonList(fluid), amount);
            }
            throw new JsonSyntaxException("fluid ingredient must have 'fluid' or 'tag' field!");
        }

        public void write(PacketBuffer buffer, FluidIngredient ingredient) {
            buffer.func_150787_b(ingredient.getFluidList().size());
            buffer.func_150787_b(ingredient.amount);
            for (Fluid fluid : ingredient.getFluidList()) {
                buffer.writeRegistryId((IForgeRegistryEntry)fluid);
            }
        }
    }
}

