/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class TagIngredient {
    private final String tagName;
    private final Collection<Item> items = new HashSet<Item>();
    private final Collection<Block> blocks = new HashSet<Block>();
    private int lastItemCheck = -1;
    private int lastBlockCheck = -1;

    public TagIngredient(String tagName) {
        this.tagName = tagName;
    }

    private void refresh() {
        if (StringUtils.func_151246_b((String)this.tagName)) {
            return;
        }
        if (this.lastItemCheck < 0 || this.lastItemCheck != ItemTags.getGeneration()) {
            Collection tmpI;
            this.items.clear();
            Tag iTag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.tagName));
            Collection collection = tmpI = iTag == null ? null : iTag.func_199885_a();
            if (tmpI != null) {
                this.items.addAll(tmpI);
            }
            this.lastItemCheck = ItemTags.getGeneration();
        }
        if (this.lastBlockCheck < 0 || this.lastBlockCheck != BlockTags.getGeneration()) {
            Collection tmpB;
            this.blocks.clear();
            Tag bTag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(this.tagName));
            Collection collection = tmpB = bTag == null ? null : bTag.func_199885_a();
            if (tmpB != null) {
                this.blocks.addAll(tmpB);
            }
            this.lastBlockCheck = BlockTags.getGeneration();
        }
    }

    public boolean apply(BlockState state) {
        return state == null || this.apply(state.func_177230_c());
    }

    public boolean apply(Block block) {
        if (block == null || block == Blocks.field_150350_a) {
            return true;
        }
        this.refresh();
        return this.blocks.parallelStream().anyMatch(val -> val.equals(block));
    }

    public boolean apply(ItemStack stack) {
        return stack == null || this.apply(stack.func_77973_b());
    }

    public boolean apply(Item item) {
        if (item == null || item == Items.field_190931_a) {
            return true;
        }
        this.refresh();
        return this.items.parallelStream().anyMatch(val -> val.equals(item));
    }
}

