/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.shapes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.JsonHelper;
import org.apache.logging.log4j.Level;

public class ExcavateShape {
    private String name = "New Shape";
    private int shape = 0;
    private int maxDepth = -1;
    private byte reticle = (byte)12;

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setReticle(int x, int y) {
        this.reticle = (byte)MathHelper.func_76125_a((int)(y * 5 + x), (int)0, (int)24);
    }

    public int getReticle() {
        return this.reticle;
    }

    public void setMaxDepth(int value) {
        this.maxDepth = value;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getShapeMask() {
        return this.shape;
    }

    public void setMask(int mask) {
        this.shape = mask;
    }

    public void setMask(int x, int y, boolean allow) {
        if (x < 0 || x >= 5 || y < 0 || y >= 5) {
            return;
        }
        int mask = ExcavateShape.posToMask(x, y);
        this.shape = allow ? (this.shape |= mask) : (this.shape &= ~mask);
    }

    public void readFromJson(JsonObject json) {
        this.name = JsonHelper.GetString(json, "name", "New Shape");
        this.maxDepth = JsonHelper.GetNumber(json, "depth", -1).intValue();
        this.reticle = (byte)MathHelper.func_76125_a((int)JsonHelper.GetNumber(json, "reticle", 12).byteValue(), (int)0, (int)24);
        JsonArray jmsk = JsonHelper.GetArray(json, "mask");
        this.shape = 0;
        int y = 4;
        for (JsonElement je : jmsk) {
            if (y < 0) break;
            if (je == null || !je.isJsonPrimitive()) continue;
            String row = je.getAsString();
            for (int x = 0; x < 5 && x < row.length(); ++x) {
                this.setMask(x, y, row.toUpperCase().charAt(x) == 'X');
            }
            --y;
        }
    }

    public JsonObject writeToJson(JsonObject json) {
        json.addProperty("name", this.name);
        json.addProperty("depth", (Number)this.maxDepth);
        json.addProperty("reticle", (Number)this.reticle);
        JsonArray jmsk = new JsonArray();
        for (int y = 4; y >= 0; --y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < 5; ++x) {
                int mask = ExcavateShape.posToMask(x, y);
                boolean valid = (this.shape & mask) == mask;
                sb.append(valid ? "X" : "O");
            }
            jmsk.add((JsonElement)new JsonPrimitive(sb.toString()));
        }
        json.add("mask", (JsonElement)jmsk);
        return json;
    }

    public boolean isValid(BlockPos origin, BlockPos offset, Direction facing) {
        int x = offset.func_177958_n() - origin.func_177958_n();
        int y = offset.func_177956_o() - origin.func_177956_o();
        int z = offset.func_177952_p() - origin.func_177952_p();
        BlockPos rotOff = this.counterRotate(new BlockPos(x, y, z), facing);
        if ((rotOff = rotOff.func_177982_a(this.reticle % 5, this.reticle / 5, 0)).func_177958_n() < 0 || rotOff.func_177958_n() >= 5 || rotOff.func_177956_o() < 0 || rotOff.func_177956_o() >= 5 || rotOff.func_177952_p() < 0 || this.maxDepth >= 0 && rotOff.func_177952_p() >= this.maxDepth) {
            return false;
        }
        int mask = ExcavateShape.posToMask(rotOff.func_177958_n(), rotOff.func_177956_o());
        return (this.shape & mask) == mask;
    }

    private BlockPos counterRotate(BlockPos pos, Direction facing) {
        switch (facing) {
            case DOWN: {
                return this.rotate(pos, Direction.DOWN);
            }
            case EAST: {
                return this.rotate(pos, Direction.WEST);
            }
            case NORTH: {
                return this.rotate(pos, Direction.NORTH);
            }
            case SOUTH: {
                return pos;
            }
            case UP: {
                return this.rotate(pos, Direction.UP);
            }
            case WEST: {
                return this.rotate(pos, Direction.EAST);
            }
        }
        return pos;
    }

    private BlockPos rotate(BlockPos pos, Direction facing) {
        switch (facing) {
            case DOWN: {
                return new BlockPos(pos.func_177958_n(), pos.func_177952_p() * -1, pos.func_177956_o() * -1);
            }
            case EAST: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n() * -1);
            }
            case NORTH: {
                return new BlockPos(pos.func_177958_n() * -1, pos.func_177956_o(), pos.func_177952_p() * -1);
            }
            case SOUTH: {
                return pos;
            }
            case UP: {
                return new BlockPos(pos.func_177958_n(), pos.func_177952_p(), pos.func_177956_o());
            }
            case WEST: {
                return new BlockPos(pos.func_177952_p() * -1, pos.func_177956_o(), pos.func_177958_n());
            }
        }
        return pos;
    }

    public static int posToMask(int x, int y) {
        int idx = y * 5 + x;
        return (int)Math.pow(2.0, idx);
    }

    public static Direction getFacing(PlayerEntity player, BlockState state, BlockPos pos) {
        BlockRayTraceResult rtr;
        try {
            double d = Math.sqrt(player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
            VoxelShape aabb = state.func_196952_d((IBlockReader)player.field_70170_p, pos);
            Vec3d v = player.func_174824_e(1.0f);
            Vec3d v2 = v.func_178787_e(player.func_70040_Z().func_186678_a(d + 1.0));
            aabb = aabb.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            rtr = aabb.func_212433_a(v, v2, pos);
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.INFO, "Unable to get excavation direction for player " + player.func_200200_C_(), (Throwable)e);
            rtr = null;
        }
        if (rtr != null) {
            return rtr.func_216354_b().func_176734_d();
        }
        return ExcavateShape.getFacing(player);
    }

    public static Direction getFacing(PlayerEntity player) {
        Vec3d dir = player.func_70040_Z();
        dir = dir.func_72432_b();
        double ax = Math.abs(dir.field_72450_a);
        double ay = Math.abs(dir.field_72448_b);
        double az = Math.abs(dir.field_72449_c);
        if (ax > ay && ax > az) {
            if (dir.field_72450_a > 0.0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (az > ay && az > ax) {
            if (dir.field_72449_c > 0.0) {
                return Direction.SOUTH;
            }
            return Direction.NORTH;
        }
        if (ay > ax && ay > az) {
            if (dir.field_72448_b > 0.0) {
                return Direction.UP;
            }
            return Direction.DOWN;
        }
        return Direction.SOUTH;
    }
}

