/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.events.EventExcavate;
import oreexcavation.events.IExcavateFilter;
import oreexcavation.groups.BlockEntry;
import oreexcavation.groups.BlockGroups;
import oreexcavation.handlers.EventHandler;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideDefault;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.ToolEffectiveCheck;
import oreexcavation.utils.XPHelper;

public class MiningAgent {
    private Item origTool;
    public final List<BlockPos> minedBlocks = new ArrayList<BlockPos>();
    private final List<BlockPos> checkedBlocks = new ArrayList<BlockPos>();
    private final ArrayDeque<BlockPos> scheduled = new ArrayDeque();
    public final ServerPlayerEntity player;
    public final BlockPos origin;
    public final UUID playerID;
    public Direction facing = Direction.SOUTH;
    public ExcavateShape shape = null;
    private final ExcavateHistory history;
    public final List<BlockEntry> blockGroup = new ArrayList<BlockEntry>();
    private final List<IExcavateFilter> filters = new ArrayList<IExcavateFilter>();
    public final BlockState state;
    private final Block block;
    public ToolOverride toolProps = ToolOverrideDefault.DEFAULT;
    private boolean strictSubs;
    public final NonNullList<BigItemStack> drops = NonNullList.func_191196_a();
    public int experience = 0;
    public final CompoundNBT auxNBT = new CompoundNBT();

    public MiningAgent(ServerPlayerEntity player, BlockPos origin, BlockState state) {
        this.player = player;
        this.origin = origin;
        this.playerID = player.func_110124_au();
        this.state = state;
        this.block = state.func_177230_c();
        this.history = new ExcavateHistory(player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
        this.blockGroup.addAll(BlockGroups.INSTANCE.getGroup(state));
        this.strictSubs = BlockGroups.INSTANCE.isStrict(state);
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        Item item = this.origTool = held.func_190926_b() ? null : held.func_77973_b();
        if (!held.func_190926_b()) {
            ToolOverride to = ToolOverrideHandler.INSTANCE.getOverride(held);
            this.toolProps = to != null ? to : this.toolProps;
        }
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void setOverride(ToolOverride override) {
        this.toolProps = override;
    }

    public void addFilter(IExcavateFilter filter) {
        this.filters.add(filter);
    }

    public void init() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    this.appendBlock(this.origin.func_177982_a(i, j, k));
                }
            }
        }
    }

    public MiningAgent setShape(ExcavateShape shape, Direction facing) {
        this.shape = shape;
        this.facing = facing;
        return this;
    }

    public boolean tickMiner(Stopwatch timer) {
        if (this.origin == null || this.player == null || !this.player.func_70089_S() || this.minedBlocks.size() >= this.toolProps.getLimit() || MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pass(this, TickEvent.Phase.START))) {
            return true;
        }
        for (int n = 0; !(this.scheduled.isEmpty() || n >= this.toolProps.getSpeed() || this.minedBlocks.size() >= this.toolProps.getLimit() || ExcavationSettings.tpsGuard && timer.elapsed(TimeUnit.MILLISECONDS) > 40L); ++n) {
            Item heldItem;
            ItemStack heldStack = this.player.func_184586_b(Hand.MAIN_HAND);
            Item item = heldItem = heldStack.func_190926_b() ? null : heldStack.func_77973_b();
            if (heldItem != this.origTool) {
                return true;
            }
            if (!this.hasEnergy(this.player)) {
                return true;
            }
            BlockPos pos = this.scheduled.poll();
            if (pos == null) continue;
            if (this.player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.toolProps.getRange() * this.toolProps.getRange())) {
                this.checkedBlocks.add(pos);
                continue;
            }
            BlockState s = this.player.field_70170_p.func_180495_p(pos);
            Block b = s.func_177230_c();
            if (EventHandler.isBlockBlacklisted(s) || s.func_185904_a() == Material.field_151581_o) {
                this.checkedBlocks.add(pos);
                continue;
            }
            boolean flag = this.strictSubs ? s == this.state : b == this.block;
            boolean bl = flag = flag || BlockGroups.INSTANCE.quickCheck(this.blockGroup, s);
            if (!flag) continue;
            CompoundNBT tileData = null;
            if (ExcavationSettings.maxUndos > 0) {
                this.player.field_70170_p.captureBlockSnapshots = true;
                this.player.field_70170_p.capturedBlockSnapshots.clear();
                TileEntity tile = this.player.field_70170_p.func_175625_s(pos);
                if (tile != null) {
                    tileData = tile.func_189515_b(new CompoundNBT());
                }
            }
            if (!ExcavationSettings.ignoreTools && !ToolEffectiveCheck.canHarvestBlock(this.player.field_70170_p, s, pos, (PlayerEntity)this.player)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            if (this.player.field_71134_c.func_180237_b(pos) || this.player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
                if (ExcavationSettings.maxUndos > 0) {
                    this.player.field_70170_p.captureBlockSnapshots = false;
                    EventHandler.captureAgent = null;
                    while (this.player.field_70170_p.capturedBlockSnapshots.size() > 0) {
                        BlockSnapshot snap = (BlockSnapshot)this.player.field_70170_p.capturedBlockSnapshots.get(0);
                        if (pos.equals((Object)snap.getPos())) {
                            this.history.addRecordedBlock(new BlockHistory(snap, tileData));
                        } else {
                            this.history.addRecordedBlock(new BlockHistory(snap));
                        }
                        this.player.field_70170_p.capturedBlockSnapshots.remove(0);
                        this.player.field_70170_p.markAndNotifyBlock(snap.getPos(), this.player.field_70170_p.func_212866_a_(snap.getPos().func_177958_n() >> 4, snap.getPos().func_177952_p() >> 4), snap.getReplacedBlock(), snap.getCurrentBlock(), snap.getFlag());
                    }
                    EventHandler.captureAgent = this;
                }
                if (!this.player.func_184812_l_()) {
                    this.player.func_71024_bL().func_75113_a(this.toolProps.getExaustion());
                    if (this.toolProps.getExperience() > 0) {
                        XPHelper.addXP((PlayerEntity)this.player, -this.toolProps.getExperience(), false);
                    }
                }
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.appendBlock(pos.func_177982_a(i, j, k));
                        }
                    }
                }
                this.minedBlocks.add(pos);
                MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Break(this, s, pos));
            } else {
                OreExcavation.logger.warn("Block harvest failed unexpectedly.\nBlock: " + s + "\nTool: " + heldStack + "\nPos: " + pos.toString());
            }
            this.player.field_70170_p.capturedBlockSnapshots.clear();
            this.player.field_70170_p.captureBlockSnapshots = false;
            this.checkedBlocks.add(pos);
        }
        if (!this.player.func_184812_l_()) {
            XPHelper.syncXP(this.player);
        }
        return this.scheduled.size() <= 0 || this.minedBlocks.size() >= this.toolProps.getLimit() || MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pass(this, TickEvent.Phase.END));
    }

    public void appendBlock(BlockPos pos) {
        if (pos == null || this.checkedBlocks.contains(pos) || this.scheduled.contains(pos)) {
            return;
        }
        if (Math.sqrt(this.player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) > (double)this.toolProps.getRange() || !this.player.field_70170_p.func_175723_af().func_177746_a(pos) || !this.canDestroy((PlayerEntity)this.player, pos)) {
            return;
        }
        if (this.shape != null && !this.shape.isValid(this.origin, pos, this.facing)) {
            return;
        }
        for (IExcavateFilter filter : this.filters) {
            if (filter.canHarvest(this.player, this, pos)) continue;
            return;
        }
        this.scheduled.add(pos);
    }

    private boolean canDestroy(PlayerEntity player, BlockPos pos) {
        if (player.field_71075_bZ.field_75099_e) {
            return true;
        }
        BlockState state = player.field_70170_p.func_180495_p(pos);
        ItemStack held = player.func_184614_ca();
        return !held.func_190926_b() && state.func_177230_c() != Blocks.field_150350_a && held.func_206848_a(player.field_70170_p.func_205772_D(), new CachedBlockInfo((IWorldReader)player.field_70170_p, pos, false));
    }

    private boolean hasEnergy(ServerPlayerEntity player) {
        return !(!(this.toolProps.getExaustion() <= 0.0f) && player.func_71024_bL().func_75116_a() <= 0 || this.toolProps.getExperience() > 0 && XPHelper.getPlayerXP((PlayerEntity)player) < (long)this.toolProps.getExperience());
    }

    public void dropEverything() {
        MiningAgent ca = EventHandler.captureAgent;
        EventHandler.captureAgent = null;
        this.history.setRecievedStacks((List<BigItemStack>)this.drops);
        this.history.setRecievedXP(this.experience);
        BlockPos pPos = this.player.func_180425_c();
        for (BigItemStack bigStack : this.drops) {
            for (ItemStack stack : bigStack.getCombinedStacks()) {
                ItemEntity eItem;
                if (!ExcavationSettings.autoPickup) {
                    eItem = new ItemEntity(this.player.field_70170_p, (double)this.origin.func_177958_n() + 0.5, (double)this.origin.func_177956_o() + 0.5, (double)this.origin.func_177952_p() + 0.5, stack);
                    this.player.field_70170_p.func_217376_c((Entity)eItem);
                    continue;
                }
                eItem = new ItemEntity(this.player.field_70170_p, (double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), stack);
                this.player.field_70170_p.func_217376_c((Entity)eItem);
            }
        }
        if (this.experience > 0) {
            ExperienceOrbEntity orb = ExcavationSettings.autoPickup ? new ExperienceOrbEntity(this.player.field_70170_p, (double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), this.experience) : new ExperienceOrbEntity(this.player.field_70170_p, (double)this.origin.func_177958_n(), (double)this.origin.func_177956_o(), (double)this.origin.func_177952_p(), this.experience);
            this.player.field_70170_p.func_217376_c((Entity)orb);
        }
        this.drops.clear();
        this.experience = 0;
        EventHandler.captureAgent = ca;
    }

    public void addItemDrop(ItemStack stack) {
        for (BigItemStack bigStack : this.drops) {
            if (!bigStack.equals(stack)) continue;
            bigStack.stackSize += stack.func_190916_E();
            return;
        }
        this.drops.add((Object)new BigItemStack(stack));
    }

    public void addExperience(int value) {
        this.experience += value;
    }

    public boolean hasMinedPosition(BlockPos pos) {
        return this.checkedBlocks.contains(pos);
    }

    public ExcavateHistory getHistory() {
        return this.history;
    }
}

