/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.config.Settings;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;

public class Profiler
implements Runnable {
    private final ConcurrentMap<Integer, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final Entity sender;
    private final ProfilingBlacklist blacklist;
    private final int chunkCount;
    private final boolean allWorlds;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(Entity sender, int chunkCount, boolean allWorlds) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<Integer, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer((ICommandSource)sender, chunkCount);
        this.allWorlds = allWorlds;
        this.blacklist = new ProfilingBlacklist();
    }

    @Override
    public void run() {
        LogHelper.warn("There will be messages about world gen lag during the profiling, you can ignore these as that is what you get when profiling.", new Object[0]);
        if (!this.allWorlds) {
            DimensionType dimensionType = this.sender.field_71093_bK;
            this.profileWorld(dimensionType);
        } else {
            for (Object o : DimensionManager.getRegistry()) {
                this.profileWorld((DimensionType)o);
            }
        }
        this.writeData();
        this.timer.complete();
    }

    private void profileWorld(DimensionType dimensionType) {
        ProfilingExecutor executor;
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)server, (DimensionType)dimensionType, (boolean)true, (boolean)true);
        if (world == null) {
            String msg = "Unable to profile dimension " + dimensionType + ".  There is no world for it.";
            LogHelper.error(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg));
            return;
        }
        ServerWorld worldServer = world;
        String msg = "Inspecting dimension " + dimensionType + ": " + worldServer.func_201675_m().func_186058_p().getRegistryName() + ". ";
        this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg));
        msg = msg + "The world thinks it is dimension " + worldServer.func_201675_m().func_186058_p().getRegistryName() + ".";
        LogHelper.info(msg, new Object[0]);
        if (Settings.excludedDimensions.contains(dimensionType.func_186068_a())) {
            msg = "Skipped dimension " + dimensionType + " during profiling";
            LogHelper.info(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg));
            return;
        }
        this.currentExecutor = executor = new ProfilingExecutor(this);
        this.allDimensionData.put(dimensionType.func_186068_a(), new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(worldServer);
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        worldServer.func_73046_m().func_213165_a((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
        dummyWorld.clearChunks();
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ProfilingBlacklist getBlacklist() {
        return this.blacklist;
    }

    public ConcurrentMap<Integer, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<Integer, ProfilingAdapter.DimensionData> allData = new HashMap<Integer, ProfilingAdapter.DimensionData>();
        for (Integer dim : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(dim);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer(dim));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put(dim, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(Entity sender, int chunks, boolean allWorlds) {
        if (currentProfiler != null && !Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        currentProfiler = new Profiler(sender, chunks, allWorlds);
        new Thread(currentProfiler).start();
        return true;
    }

    public static boolean stop() {
        if (currentProfiler == null || Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        if (Profiler.currentProfiler.currentExecutor != null) {
            Profiler.currentProfiler.currentExecutor.shutdownNow();
        }
        currentProfiler.writeData();
        return true;
    }
}

