/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.eapi.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.EdCraftingTable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("engineersdecor", "jei_plugin_uid");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!ModConfig.without_crafting_table) {
            try {
                registration.addRecipeTransferHandler(EdCraftingTable.CraftingTableContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 44);
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().warn("Exception in JEI crafting table handler registration: '" + e.getMessage() + "'.");
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList<ItemStack> blacklisted = new ArrayList<ItemStack>();
        for (Block e : ModContent.getRegisteredBlocks()) {
            if (!ModConfig.isOptedOut(e)) continue;
            blacklisted.add(new ItemStack((IItemProvider)e.func_199767_j()));
        }
        if (!blacklisted.isEmpty()) {
            try {
                jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, blacklisted);
            }
            catch (Exception e) {
                ModEngineersDecor.logger().warn("Exception in JEI opt-out processing: '" + e.getMessage() + "', skipping further JEI optout processing.");
            }
        }
    }
}

