/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsLang;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemMekanismHoe
extends HoeItem
implements IHasRepairType {
    private static final ToolType HOE_TOOL_TYPE = ToolType.get((String)"hoe");
    private final BaseMekanismMaterial material;

    public ItemMekanismHoe(BaseMekanismMaterial material) {
        super((IItemTier)material, material.getHoeAtkSpeed(), ItemDeferredRegister.getMekBaseProperties().addToolType(HOE_TOOL_TYPE, material.func_200925_d()));
        this.material = material;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ToolsLang.HP.translate(new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200891_e().func_200924_f();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.func_200891_e().func_200926_a();
    }

    public boolean func_77645_m() {
        return this.func_200891_e().func_200926_a() > 0;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        HashMultimap attributes = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
            attributes.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.material.getHoeAtkSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return attributes;
    }
}

