/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.vanilla;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPadTorch
extends TorchBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public static final VoxelShape PAD_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    public static final VoxelShape SHAPE = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.5, (double)10.0), (VoxelShape)PAD_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public BlockPadTorch(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return PAD_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HORIZONTAL_FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        double offset = 0.025;
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y + offset, z, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y + offset, z, 0.0, 0.0, 0.0);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (worldIn instanceof ServerWorld && entityIn instanceof BoatEntity) {
            worldIn.func_225521_a_(new BlockPos((Vec3i)pos), true, entityIn);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_221657_bQ);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos blockpos) {
        return this.isValidGround(worldIn.func_180495_p(blockpos.func_177977_b()), (IBlockReader)worldIn, blockpos.func_177977_b());
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a || state.func_185904_a() == Material.field_151588_w;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public static class ColorHandler
    implements IBlockColor {
        public int getColor(BlockState state, @Nullable ILightReader reader, @Nullable BlockPos blockPos, int tintIndex) {
            if (reader != null && blockPos != null) {
                return BiomeColors.func_228361_b_((ILightReader)reader, (BlockPos)blockPos);
            }
            return GrassColors.func_77480_a((double)0.5, (double)1.0);
        }
    }
}

