/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class WindowItemsFragmentPacket
extends PacketCodec {
    @CodecField
    private int windowId;
    @CodecField
    private CompoundNBT itemStacks;

    public WindowItemsFragmentPacket() {
    }

    public WindowItemsFragmentPacket(int windowId, CompoundNBT itemStacks) {
        this.windowId = windowId;
        this.itemStacks = itemStacks;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (this.windowId == 0) {
            this.putStacksInSlotsWithOffset((Container)player.field_71069_bz);
        } else if (this.windowId == player.field_71070_bA.field_75152_c) {
            this.putStacksInSlotsWithOffset(player.field_71070_bA);
        }
    }

    protected void putStacksInSlotsWithOffset(Container container) {
        ListNBT list = this.itemStacks.func_150295_c("stacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("slot");
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("stack"));
            container.func_75141_a(slot, stack);
        }
    }

    public void actionServer(World world, ServerPlayerEntity player) {
    }
}

