/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.colossalchests.tileentity.TileUncolossalChest;
import org.cyclops.cyclopscore.block.BlockTileGui;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class UncolossalChest
extends BlockTileGui
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public UncolossalChest(Block.Properties properties) {
        super(properties, TileUncolossalChest::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING}).func_206894_a(new IProperty[]{WATERLOGGED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState p_190946_1_) {
        return true;
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction facing = blockItemUseContext.func_195992_f().func_176734_d();
        return (BlockState)super.func_196258_a(blockItemUseContext).func_206870_a((IProperty)FACING, (Comparable)facing);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileUncolossalChest tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = (TileUncolossalChest)TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileUncolossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.func_200301_q());
        }
    }

    public IFluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileUncolossalChest.class).map(tile -> Container.func_94526_b((IInventory)tile.getInventory())).orElse(0);
    }

    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a((IProperty)FACING, (Comparable)rotation.func_185831_a((Direction)blockState.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a((Direction)blockState.func_177229_b((IProperty)FACING)));
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, World p_220052_2_, BlockPos p_220052_3_) {
        return super.func_220052_b(p_220052_1_, p_220052_2_, p_220052_3_);
    }
}

