/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block.redstone;

import java.util.ArrayDeque;
import java.util.Queue;
import me.jellysquid.mods.lithium.common.block.redstone.RedstoneLogic;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateFlag;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateGraph;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateNode;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneEngine {
    private final Queue<UpdateNode> brightenQueue = new ArrayDeque<UpdateNode>();
    private final Queue<UpdateNode> darkenQueue = new ArrayDeque<UpdateNode>();
    private final Queue<UpdateNode> updateQueue = new ArrayDeque<UpdateNode>();
    private final UpdateGraph graph;
    private boolean isUpdatingBlocks;

    public RedstoneEngine(World world) {
        this.graph = new UpdateGraph(world);
    }

    public void notifyWireAdded(BlockPos pos) {
        UpdateNode node = this.graph.getOrCreateNode(pos);
        node.invalidateWorldState();
        this.updateQueue.add(node);
        this.brightenNode(node, node.calculateIncomingEffectivePower());
        this.processGraphChanges();
    }

    public void notifyWireRemoved(BlockPos pos, int prev) {
        UpdateNode node = this.graph.getOrCreateNode(pos);
        node.invalidateWorldState();
        node.invalidateConnections();
        this.updateQueue.add(node);
        this.enqueueNeighbors(node, prev, true);
        this.processGraphChanges();
    }

    public void notifyWireNeighborChanged(BlockPos pos, int prev) {
        int cur;
        UpdateNode node = this.graph.get(pos);
        if (node != null) {
            if (node.getCurrentWirePower() == prev) {
                return;
            }
        } else {
            node = this.graph.getOrCreateNode(pos);
        }
        if ((cur = node.calculateIncomingEffectivePower()) > prev) {
            this.brightenNode(node, cur);
            this.updateQueue.add(node);
        } else if (cur < prev) {
            this.darkenNode(node, prev);
            this.updateQueue.add(node);
        }
        this.processGraphChanges();
    }

    private void brightenNode(UpdateNode node, int level) {
        node.setCurrentWirePower(level);
        node.updateWireState();
        this.brightenQueue.add(node);
    }

    private void darkenNode(UpdateNode node, int level) {
        node.setDarkeningThreshold(level);
        node.setCurrentWirePower(0);
        node.updateWireState();
        this.darkenQueue.add(node);
    }

    private void enqueueNeighbors(UpdateNode node, int power, boolean darkening) {
        boolean canAscend = !node.getAdjacent(Direction.UP).isFullBlock();
        boolean canDescend = darkening || node.getAdjacent(Direction.DOWN).isFullBlock();
        for (Direction dir : RedstoneLogic.WIRE_NEIGHBORS_HORIZONTAL) {
            UpdateNode adj = node.getAdjacent(dir);
            this.enqueueNode(node, adj, power, darkening);
            if (canAscend) {
                this.enqueueNode(node, adj.getAdjacent(Direction.UP), power, darkening);
            }
            if (!canDescend || adj.isFullBlock()) continue;
            this.enqueueNode(node, adj.getAdjacent(Direction.DOWN), power, darkening);
        }
    }

    private void enqueueNode(UpdateNode node, UpdateNode adj, int power, boolean darkening) {
        if (!adj.isWireBlock()) {
            return;
        }
        boolean result = darkening ? this.enqueueNodeForDarkening(adj, power) : this.enqueueNodeForBrightening(adj, power);
        if (result) {
            node.addConnection(adj);
        }
    }

    private boolean enqueueNodeForDarkening(UpdateNode node, int power) {
        if (!node.checkAndMarkFlag(UpdateFlag.DARKENED)) {
            return false;
        }
        int neighborPower = node.getCurrentWirePower();
        if (neighborPower > 0 && neighborPower < power) {
            this.darkenNode(node, neighborPower);
            return true;
        }
        if (neighborPower >= power - 1) {
            this.brightenQueue.add(node);
        }
        return false;
    }

    private boolean enqueueNodeForBrightening(UpdateNode node, int power) {
        if (!node.checkAndMarkFlag(UpdateFlag.BRIGHTENED)) {
            return false;
        }
        if (node.getCurrentWirePower() + 1 < power) {
            this.brightenNode(node, power - 1);
            return true;
        }
        return false;
    }

    private void processBlockUpdates() {
        if (this.isUpdatingBlocks) {
            return;
        }
        this.isUpdatingBlocks = true;
        while (!this.updateQueue.isEmpty()) {
            UpdateNode node = this.updateQueue.remove();
            if (!node.checkAndMarkFlag(UpdateFlag.WIRE_UPDATED)) continue;
            for (Direction dir1 : RedstoneLogic.BLOCK_NEIGHBOR_UPDATE_ORDER) {
                UpdateNode adj1 = node.getAdjacent(dir1);
                if (adj1.checkAndMarkFlag(UpdateFlag.NEIGHBOR_UPDATED)) {
                    adj1.update(node, dir1, true);
                }
                for (Direction dir2 : RedstoneLogic.BLOCK_NEIGHBOR_UPDATE_ORDER) {
                    UpdateNode adj2 = adj1.getAdjacent(dir2);
                    if (!adj2.checkAndMarkFlag(UpdateFlag.QUASI_NEIGHBOR_UPDATED)) continue;
                    adj2.update(adj1, dir2, false);
                }
            }
            if (!node.isWireAtValidLocation()) {
                node.destroyWire();
            }
            this.updateQueue.addAll(node.getConnections());
        }
        this.graph.clear();
        this.isUpdatingBlocks = false;
    }

    private void processGraphChanges() {
        this.processQueuedDarkenings();
        this.processQueuedBrightenings();
        this.resetGraphTraversalState();
        this.processBlockUpdates();
    }

    private void resetGraphTraversalState() {
        for (UpdateNode node : this.graph) {
            node.clearFlags();
        }
    }

    private void processQueuedDarkenings() {
        while (!this.darkenQueue.isEmpty()) {
            UpdateNode node = this.darkenQueue.poll();
            this.enqueueNeighbors(node, node.getDarkeningThreshold(), true);
        }
    }

    private void processQueuedBrightenings() {
        while (!this.brightenQueue.isEmpty()) {
            UpdateNode node = this.brightenQueue.poll();
            this.enqueueNeighbors(node, node.getCurrentWirePower(), false);
        }
    }
}

