/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.data;

import com.progwml6.ironchest.IronChests;
import com.progwml6.ironchest.common.Util;
import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.item.IronChestsItems;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IronChestsLangProvider
extends LanguageProvider {
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public IronChestsLangProvider(DataGenerator gen) {
        super(gen, "ironchest", "en_us");
        this.upsideDown = new AccessibleLanguageProvider(gen, "ironchest", "en_ud");
    }

    protected void addTranslations() {
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.IRON_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.GOLD_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.DIAMOND_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.COPPER_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.SILVER_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.CRYSTAL_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.OBSIDIAN_CHEST);
        this.addBlock((Supplier<? extends Block>)IronChestsBlocks.DIRT_CHEST);
        IronChestsItems.UPGRADES.values().forEach(this::addItem);
        this.add(IronChests.IRONCHESTS_ITEM_GROUP, "Iron Chests");
    }

    private String getAutomaticName(Supplier<? extends IForgeRegistryEntry<?>> sup) {
        return Util.toEnglishName(sup.get().getRegistryName().func_110623_a());
    }

    private void addBlock(Supplier<? extends Block> block) {
        this.addBlock(block, this.getAutomaticName(block));
    }

    private void addItem(Supplier<? extends Item> item) {
        this.addItem(item, this.getAutomaticName(item));
    }

    private void addItemWithTooltip(Supplier<? extends Item> block, String name, List<String> tooltip) {
        this.addItem(block, name);
        this.addTooltip(block, tooltip);
    }

    private void addTooltip(Supplier<? extends IItemProvider> item, String tooltip) {
        this.add(item.get().func_199767_j().func_77658_a() + ".desc", tooltip);
    }

    private void addTooltip(Supplier<? extends IItemProvider> item, List<String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            this.add(item.get().func_199767_j().func_77658_a() + ".desc." + i, tooltip.get(i));
        }
    }

    private void add(ItemGroup group, String name) {
        this.add(group.func_78024_c(), name);
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                String fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < fmtArg.length(); ++j) {
                    ud[normal.length() - 1 - i + j] = fmtArg.charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        super.func_200398_a(cache);
        this.upsideDown.func_200398_a(cache);
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends LanguageProvider {
        public AccessibleLanguageProvider(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        public void add(String key, String value) {
            super.add(key, value);
        }

        protected void addTranslations() {
        }
    }
}

