/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRequest {
    private BlockPos pos;
    private ItemStack stack;
    private int amount;

    public PacketRequest(BlockPos pos, ItemStack stack, int amount) {
        this.pos = pos;
        this.stack = stack;
        this.amount = amount;
    }

    private PacketRequest() {
    }

    public static PacketRequest fromBytes(PacketBuffer buf) {
        PacketRequest packet = new PacketRequest();
        packet.pos = buf.func_179259_c();
        packet.stack = buf.func_150791_c();
        packet.amount = buf.func_150792_a();
        return packet;
    }

    public static void toBytes(PacketRequest packet, PacketBuffer buf) {
        buf.func_179255_a(packet.pos);
        buf.func_150788_a(packet.stack);
        buf.func_150787_b(packet.amount);
    }

    public static void onMessage(final PacketRequest message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemTerminalTileEntity tile = Utility.getTileEntity(ItemTerminalTileEntity.class, player.field_70170_p, message.pos);
                message.stack.func_190920_e(message.amount);
                tile.requestItem((PlayerEntity)player, message.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

