/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SecurityHelper {
    public static final GameProfile DEFAULT_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static UUID cachedId;

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uuid) {
        return uuid == null || uuid.version() == 4 && uuid.variant() == 0;
    }

    public static boolean isDefaultProfile(GameProfile profile) {
        return DEFAULT_GAME_PROFILE.equals((Object)profile);
    }

    public static UUID getID(PlayerEntity player) {
        if (player == null) {
            return DEFAULT_GAME_PROFILE.getId();
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.func_71278_l()) {
            return player.func_146103_bH().getId();
        }
        return SecurityHelper.getClientID(player);
    }

    private static UUID getClientID(PlayerEntity player) {
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return player.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static boolean canPlayerAccess(ItemStack stack, PlayerEntity player) {
        return !SecurityHelper.hasSecurity(stack) || SecurityHelper.getAccess(stack).matches(SecurityHelper.getOwner(stack), player);
    }

    public static CompoundNBT setItemStackTagSecurity(CompoundNBT tag, ISecurable tile) {
        if (tile == null) {
            return tag;
        }
        if (tag == null) {
            tag = new CompoundNBT();
        }
        CompoundNBT secureTag = new CompoundNBT();
        secureTag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
        secureTag.func_74778_a("OwnerUUID", tile.getOwner().getId().toString());
        secureTag.func_74778_a("OwnerName", tile.getOwner().getName());
        tag.func_218657_a("Security", (INBT)secureTag);
        return tag;
    }

    public static void addAccessInformation(ItemStack stack, List<String> tooltip) {
        if (SecurityHelper.hasSecurity(stack)) {
            String accessString = "";
            switch (ISecurable.AccessMode.VALUES[stack.func_179543_a("Security").func_74771_c("Access")]) {
                case PUBLIC: {
                    accessString = StringHelper.localize("info.cofh.access_public");
                    break;
                }
                case PRIVATE: {
                    accessString = StringHelper.localize("info.cofh.access_private");
                    break;
                }
                case FRIENDS: {
                    accessString = StringHelper.localize("info.cofh.access_friends");
                    break;
                }
                case TEAM: {
                    accessString = StringHelper.localize("info.cofh.access_team");
                }
            }
            tooltip.add(StringHelper.localize("info.cofh.access") + ": " + accessString);
        }
    }

    public static void addOwnerInformation(ItemStack stack, List<String> tooltip) {
        if (SecurityHelper.hasSecurity(stack)) {
            CompoundNBT secureTag = stack.func_179543_a("Security");
            boolean hasUUID = secureTag.func_74764_b("OwnerUUID");
            if (!secureTag.func_74764_b("OwnerName") && !hasUUID) {
                tooltip.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (hasUUID && secureTag.func_74764_b("OwnerName")) {
                tooltip.add(StringHelper.localize("info.cofh.owner") + ": " + secureTag.func_74779_i("OwnerName") + " \u0378");
            } else {
                tooltip.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.another_player"));
            }
        }
    }

    public static boolean hasSecurity(TileEntity tile) {
        if (tile instanceof ISecurable) {
            return !SecurityHelper.isDefaultProfile(((ISecurable)tile).getOwner());
        }
        return false;
    }

    public static String getOwnerName(TileEntity tile) {
        if (SecurityHelper.hasSecurity(tile)) {
            return ((ISecurable)tile).getOwnerName();
        }
        return DEFAULT_GAME_PROFILE.getName();
    }

    public static boolean hasSecurity(ItemStack stack) {
        return stack.func_179543_a("Security") != null;
    }

    public static ItemStack addSecurity(ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            return stack;
        }
        CompoundNBT secureTag = new CompoundNBT();
        secureTag.func_74774_a("Access", (byte)0);
        stack.func_77983_a("Security", (INBT)secureTag);
        return stack;
    }

    public static ItemStack removeSecurity(ItemStack stack) {
        if (!SecurityHelper.hasSecurity(stack)) {
            return stack;
        }
        stack.func_196083_e("Security");
        return stack;
    }

    public static void setAccess(ItemStack stack, ISecurable.AccessMode access) {
        if (!SecurityHelper.hasSecurity(stack)) {
            return;
        }
        CompoundNBT secureTag = stack.func_179543_a("Security");
        secureTag.func_74774_a("Access", (byte)access.ordinal());
    }

    public static void setOwner(ItemStack stack, GameProfile profile) {
        if (!SecurityHelper.hasSecurity(stack)) {
            return;
        }
        CompoundNBT secureTag = stack.func_179543_a("Security");
        secureTag.func_74778_a("OwnerUUID", profile.getId().toString());
        secureTag.func_74778_a("OwnerName", profile.getName());
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        return !SecurityHelper.hasSecurity(stack) ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.VALUES[stack.func_179543_a("Security").func_74771_c("Access")];
    }

    public static GameProfile getOwner(ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            CompoundNBT secureTag = stack.func_179543_a("Security");
            String uuid = secureTag.func_74779_i("OwnerUUID");
            String name = secureTag.func_74779_i("OwnerName");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_187473_a((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (String)name)), name);
            }
        }
        return DEFAULT_GAME_PROFILE;
    }

    public static GameProfile getProfile(UUID uuid, String name) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        GameProfile owner = server.func_152358_ax().func_152652_a(uuid);
        if (owner == null) {
            GameProfile temp = new GameProfile(uuid, name);
            owner = server.func_147130_as().fillProfileProperties(temp, true);
            if (owner != temp) {
                server.func_152358_ax().func_152649_a(owner);
            }
        }
        return owner;
    }

    public static String getOwnerName(ItemStack stack) {
        boolean hasUUID;
        CompoundNBT secureTag = stack.func_179543_a("Security");
        if (secureTag == null || !(hasUUID = secureTag.func_74764_b("OwnerUUID")) && !secureTag.func_74764_b("OwnerName")) {
            return DEFAULT_GAME_PROFILE.getName();
        }
        return hasUUID ? secureTag.func_74779_i("OwnerName") : StringHelper.localize("info.cofh.another_player");
    }
}

