/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.core.network.packet.server.TransferControlPacket;
import cofh.lib.util.Utils;
import cofh.lib.util.control.ITransferControllable;
import cofh.lib.util.control.ITransferControllableTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class TransferControlModule
implements ITransferControllable {
    protected ITransferControllableTile tile;
    protected boolean hasAutoInput;
    protected boolean hasAutoOutput;
    protected boolean enableAutoInput;
    protected boolean enableAutoOutput;

    public TransferControlModule(ITransferControllableTile tile) {
        this(tile, true, true);
    }

    public TransferControlModule(ITransferControllableTile tile, boolean hasAutoInput, boolean hasAutoOutput) {
        this.tile = tile;
        this.hasAutoInput = hasAutoInput;
        this.hasAutoOutput = hasAutoOutput;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.hasAutoInput = buffer.readBoolean();
        this.hasAutoOutput = buffer.readBoolean();
        this.enableAutoInput = buffer.readBoolean();
        this.enableAutoOutput = buffer.readBoolean();
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasAutoInput);
        buffer.writeBoolean(this.hasAutoOutput);
        buffer.writeBoolean(this.enableAutoInput);
        buffer.writeBoolean(this.enableAutoOutput);
    }

    public TransferControlModule read(CompoundNBT nbt) {
        this.enableAutoInput = nbt.func_74767_n("EnableIn");
        this.enableAutoOutput = nbt.func_74767_n("EnableOut");
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74757_a("EnableIn", this.enableAutoInput);
        nbt.func_74757_a("EnableOut", this.enableAutoOutput);
        return nbt;
    }

    @Override
    public boolean hasTransferIn() {
        return this.hasAutoInput;
    }

    @Override
    public boolean hasTransferOut() {
        return this.hasAutoOutput;
    }

    @Override
    public boolean getTransferIn() {
        return this.hasTransferIn() && this.enableAutoInput;
    }

    @Override
    public boolean getTransferOut() {
        return this.hasTransferOut() && this.enableAutoOutput;
    }

    @Override
    public void setControl(boolean input, boolean output) {
        boolean curInput = this.enableAutoInput;
        boolean curOutput = this.enableAutoOutput;
        if (this.hasTransferIn()) {
            this.enableAutoInput = input;
        }
        if (this.hasTransferOut()) {
            this.enableAutoOutput = output;
        }
        if (Utils.isClientWorld(this.tile.world())) {
            TransferControlPacket.sendToServer(this.tile);
            this.enableAutoInput = curInput;
            this.enableAutoOutput = curOutput;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

